<?php

namespace app\Model\Api\V1;

use app\Enums\AddressType;
use app\Model\Api\V1\User;
use app\Rules\AddressTypeRule;
use BenSampo\Enum\Rules\EnumValue;
use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    /**
     * attributes of model which can not be mass-assigned.
     *
     * @var array
     */
    protected $guarded = [];

    public static function rules($id = null)
    {
        return [
            'contact_person' => 'bail|required|max:' . config('api.constants.address.contact_person.maxLength'),
            'address1'       => 'bail|required|max:' . config('api.constants.address.address1.maxLength'),
            'city'           => 'bail|required|max:' . config('api.constants.address.city.maxLength'),
            'state'          => 'bail|required|max:' . config('api.constants.address.state.maxLength'),
            'address_type'   => ['bail', 'required', new EnumValue(AddressType::class), new AddressTypeRule($id)],
        ];
    }

    public static function messages()
    {
        return [];
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    function list($request)
    {
        $limit = $request->query('limit', config('api.constants.DEFAULT_PAGE_LIMIT'));
        $query = self::query();
        $query->when(isset($request->userId), function ($q) use ($request) {
            return $q->where('user_id', $request->userId);
        });
        $query->when(isset($request->address_type), function ($q) use ($request) {
            return $q->where('address_type', $request->address_type);
        });
        return $query->paginate($limit);
    }
}
