<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class UpdateApp extends Model {

protected $guarded = ['_token'];
protected $tables= 'update_apps';
protected $hidden = ['created_at', 'updated_at'];

    
public static function rules($id = null)
{
    return [
        'android_version' => 'bail|required|string|min:' . \Config::get('admin.constants.app-version.android_version.minLength') . '|max:' . \Config::get('admin.constants.app-version.android_version.maxLength'),
        'ios_version' => 'bail|required|string|min:' . \Config::get('admin.constants.app-version.ios_version.minLength') . '|max:' . \Config::get('admin.constants.app-version.ios_version.maxLength'),
        'android_update_message' => 'string|required',
        'ios_update_message' => 'string|required',
        'force_update_ios' => 'bail|required',
        'force_update_android' => 'bail|required',
    ];
}

public static function messages()
{
    return [
        'android_version.required' => __('admin/validation/app-version.android_version.required'),
        'android_version.min' => __('admin/validation/app-version.android_version.min'),
        'android_version.max' => __('admin/validation/app-version.android_version.max'),
       // 'android_version.regex' =>  __('admin/validation/app-version.android_version.regex'),

        'ios_version.required' => __('admin/validation/app-version.ios_version.required'),
        'ios_version.min' => __('admin/validation/app-version.ios_version.min'),
        'ios_version.max' => __('admin/validation/app-version.ios_version.max'),
       // 'ios_version.regex' =>  __('admin/validation/app-version.ios_version.regex'),
        'android_update_message.required' => __('admin/validation/app-version.android_update_message.required'),
        'ios_update_message.required' => __('admin/validation/app-version.ios_update_message.required'),

        'force_update_ios.required' => __('admin/validation/app-version.ios_version.required'),
        'force_update_android.required' => __('admin/validation/app-version.force_update_android.required'),
    ];
}

}