<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class StaticPage extends Model
{

    use Sortable;

    protected $table = 'static_pages';
    protected $guarded = ['_token'];
    protected $hidden = ['created_at', 'updated_at'];
    public $sortable = ['id', 'title', 'url', 'slug', 'meta_title', 'meta_description', 'content', 'created_at', 'status', 'updated_at'];

    public static function rules($id = null)
    {
        return [
            'content' => 'bail|required|string|min:' . config('admin.constants.static-page.content.minLength'),

            'meta_title' => 'bail|required|string|min:' . config('admin.constants.static-page.meta_title.minLength') . '|max:' . config('admin.constants.static-page.meta_title.maxLength'),

            'meta_description' => 'bail|required|string|min:' . config('admin.constants.static-page.meta_description.minLength'),
        ];
    }

    public static function messages()
    {
        return [
            'content.required' => __('admin/validation/static-page.content.required'),
            'content.min' => __('admin/validation/static-page.content.min'),
            'content.max' => __('admin/validation/static-page.content.max'),

            'meta_title.required' => __('admin/validation/static-page.meta_title.required'),
            'meta_title.min' => __('admin/validation/static-page.meta_title.min'),
            'meta_title.max' => __('admin/validation/static-page.meta_title.max'),
            'meta_title.unique' => __('admin/validation/static-page.meta_title.unique'),

            'meta_description.required' => __('admin/validation/static-page.meta_description.required'),
            'meta_description.min' => __('admin/validation/static-page.meta_description.min'),
            'meta_description.max' => __('admin/validation/static-page.meta_description.max'),
        ];
    }

    

}
