<?php
namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;

class SmtpSetting extends Model
{
    protected $guarded = ['_token'];
    protected $hidden = ['created_at', 'updated_at'];

    public static function rules($id = null)
    {
        return [
            'driver' => 'bail|required|string|min:' . config('admin.constants.smtp-setting.driver.minLength') . '|max:' . config('admin.constants.smtp-setting.driver.maxLength'),

            'host' => 'bail|required|string|min:' . config('admin.constants.smtp-setting.host.minLength') . '|max:' . config('admin.constants.smtp-setting.host.maxLength'),

            'port' => 'bail|required|string|min:' . config('admin.constants.smtp-setting.port.minLength') . '|max:' . config('admin.constants.smtp-setting.port.maxLength'),

            'username' => 'bail|required|string|min:' . config('admin.constants.smtp-setting.username.minLength') . '|max:' . config('admin.constants.smtp-setting.username.maxLength'),

            'password' => 'bail|required|string|min:' . config('admin.constants.smtp-setting.password.minLength') . '|max:' . config('admin.constants.smtp-setting.password.maxLength'),

            'encryption' => 'bail|nullable|string|min:' . config('admin.constants.smtp-setting.encryption.minLength') . '|max:' . config('admin.constants.smtp-setting.encryption.maxLength'),
        ];
    }

    public static function messages()
    {
        return [
            'driver.required' => __('admin/validation/smtp-setting.driver.required'),
            'driver.min' => __('admin/validation/smtp-setting.driver.min'),
            'driver.max' => __('admin/validation/smtp-setting.driver.max'),

            'host.required' => __('admin/validation/smtp-setting.host.required'),
            'host.min' => __('admin/validation/smtp-setting.host.min'),
            'host.max' => __('admin/validation/smtp-setting.host.max'),

            'port.required' => __('admin/validation/smtp-setting.port.required'),
            'port.min' => __('admin/validation/smtp-setting.port.min'),
            'port.max' => __('admin/validation/smtp-setting.port.max'),

            'username.required' => __('admin/validation/smtp-setting.username.required'),
            'username.min' => __('admin/validation/smtp-setting.username.min'),
            'username.max' => __('admin/validation/smtp-setting.username.max'),

            'password.required' => __('admin/validation/smtp-setting.password.required'),
            'password.min' => __('admin/validation/smtp-setting.password.min'),
            'password.max' => __('admin/validation/smtp-setting.password.max'),

            'encryption.required' => __('admin/validation/smtp-setting.encryption.required'),
            'encryption.min' => __('admin/validation/smtp-setting.encryption.min'),
            'encryption.max' => __('admin/validation/smtp-setting.encryption.max'),
        ];
    }
}
