<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Kyslik\ColumnSortable\Sortable;

class Role extends Model
{

    use Sortable;

    protected $tables = 'roles';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['id', 'name', 'description', 'status', 'is_super_admin', 'created_at', 'updated_at'];
    public $sortable = ['id', 'name', 'description'];

    public static function rules($id = null)
    {
        return [
            'name' => 'required|unique:roles,name,' . ($id ? $id : '') . '|max:' . config('admin.constants.role.name.maxLength'),
            'description' => 'required|max:' . config('admin.constants.role.description.maxLength'),
        ];
    }

    public static function messages()
    {
        return [
            'name.required' => __('admin/validation/role.name.required'),
            'name.min' => __('admin/validation/role.name.min'),
            'name.max' => __('admin/validation/role.name.max'),
            'name.regex' => __('admin/validation/role.name.regex'),
            'description.required' => __('admin/validation/role.description.required'),
            'description.max' => __('admin/validation/role.description.max'),
        ];
    }

    //@author:Rahul
    //@description: Below function uses for role id.
    //@param  string  $roleName
    //return : int roleid

    public function getRoleId($roleName = null)
    {
        $roleId = Role::where([['name', '=', strtolower($roleName)]])->first();
        return $roleId->id;
    }

    //@author:Rahul
    //@description: Below function uses for permission.
    //@param  string  $roleName
    //return : true or false
    public static function hasRole($request)
    {
        if (Auth::guard('admin')->check()) {
            $currentRoleId = Auth::guard('admin')->user()->role_id;
        } else {
            $currentRoleId = Auth::user()->role_id;
        }
        $currentRole = Role::with(['permissions', 'permissions.modules'])->where('id', '=', $currentRoleId)->first();
        if ($currentRole->is_super_admin) {
            return true;
        } else {
            $routeArray = $request->route()->getAction();
            $controllerAction = class_basename($routeArray['controller']);
            list($controller, $action) = explode('@', $controllerAction);

            $permissionFlag = false;
            if (!empty($currentRole->permissions)) {
                foreach ($currentRole->permissions as $permitted) {
                    if ($permitted->modules->controller == $controller) {
                        if ($permitted->modules->action == $action) {
                            $permissionFlag = true;
                            break;
                        }
                        if ($action == 'update' || $action == 'store') {
                            $permissionFlag = true;
                            break;
                        }
                    }
                }
                foreach (config('admin.constants.AdminAllowedBasicActions') as $actionValue => $controllerKey) {
                    if ($controllerKey == $controller && $actionValue == $action) {
                        $permissionFlag = true;
                    }

                }
            }
            return $permissionFlag;
        }
    }

    //@author:Bibhash
    //@description: Below function uses for permission.
    //@param  string  $vendorHasRole
    //return : true or false
    public static function vendorHasRole($request)
    {
        if (Auth::guard('restaurant')->check()) {
            $currentRoleId = Auth::guard('restaurant')->user()->role_id;
        } else {
            $currentRoleId = Auth::user()->role_id;
        }
        $currentRole = Role::with(['permissions', 'permissions.modules'])->where('id', '=', $currentRoleId)->first();
        if ($currentRole->is_super_admin) {
            return true;
        } else {
            $routeArray = $request->route()->getAction();
            $controllerAction = class_basename($routeArray['controller']);
            list($controller, $action) = explode('@', $controllerAction);

            $permissionFlag = false;
            if (!empty($currentRole->permissions)) {
                foreach ($currentRole->permissions as $permitted) {
                    if ($permitted->modules->controller == $controller) {
                        if ($permitted->modules->action == $action) {
                            $permissionFlag = true;
                            break;
                        }
                        if ($action == 'update' || $action == 'store') {
                            $permissionFlag = true;
                            break;
                        }
                    }
                }
                foreach (config('admin.constants.VendorAllowedBasicActions') as $actionValue => $controllerKey) {
                    if ($controllerKey == $controller && $actionValue == $action) {
                        $permissionFlag = true;
                    }

                }
            }
            return $permissionFlag;
        }
    }

    //@author:Rahul
    //@description: Below function uses for permission.
    //@param  string  $roleName
    //return : true or false
    public function fetchRoleList($request)
    {
        $pageSize = config('admin.constants.AdminPageSize');
        $search = !empty($request->search) ? $request->search : '';
        $query = Role::where('name', '!=', 'Super_admin')->where('name', '!=', config("admin.constants.userRoleAdmin"));
        if (!empty($search)) {
            $query->whereRaw(\DB::raw('(name like "%' . $search . '%")'));
        }
        $roles = $query->sortable(['id' => 'desc'])->paginate($pageSize);
        return $roles;
    }

    //@author:Rahul
    //@description: To fetch all roles to consume in permisssons controller
    //@param  null
    //return : all roles except Super_admin
    public function fetchAllRoles()
    {
        return Role::where('name', '!=', 'Super_admin')->sortable(['id' => 'desc'])->get();
    }

    public static function gettyRole()
    {
        $currentRoleId = \Auth::user()->role_id;
        $roleName = Role::where([['id', '=', $currentRoleId]])->first();
        $loginRole = !empty($roleName->name) ? $roleName->name : '';
        if (!empty($loginRole) && ucfirst($loginRole) == 'Getty') {
            return true;
        } else {
            return false;
        }
    }

    public function userList()
    {

        return $this->hasMany('App\Model\Admin\User');
    }

    public function users()
    {

        return $this->hasMany('app\Model\Admin\User', 'role_id', 'id');
    }

    public function permissions()
    {

        return $this->hasMany('app\Model\Admin\Permissions', 'role_id', 'id');
    }

}
