<?php

namespace app\Model\Admin;

use app\Model\Admin\UserAvatars;
use Illuminate\Database\Eloquent\Model;
use app\Traits\FilePathUrl;
use File;
use Image;

class Restaurant extends Model
{
    protected $tables = 'restaurants';
    //protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['owner_id', 'name', 'bio', 'resturent_type_local', 'resturent_type_continental', 'resturent_type_groceries', 'address1', 'address2', 'city', 'region', 'zipcode', 'delivery_time', 'latitude', 'longitude', 'is_include_commission', 'status'];
    //protected $fillable = ['owner_id'];
    //protected $guarded = [];
    //public $sortable = ['name'];

    public static function rules($id = null)
    {
        //dd($id);
        return [
            'restaurant_name' => 'bail|required|string',
            'restaurant_bio' => 'bail|required|string',
            'country' => 'bail|required|string',
            'restaurant_phone_number' => 'bail|required|string|unique:users,phone_number,' . ($id ? $id : '') . '|min:' . config('admin.constants.user.phone_number.minLength') . '|max:' . config('admin.constants.user.phone_number.maxLength'),
            'address1' => 'bail|required|string',
            'address2' => 'bail|required|string',
            'locality' => 'bail|required|string',
            'deliverytime' => 'bail|required|string',
            //'postcode' => 'bail|required|string',
            //'avatar' => 'bail|nullable|mimes:' . config('admin.constants.user.avatar.mimes') . '|max:' . config('admin.constants.user.avatar.size'), //formats: jpeg, png, bmp, gif, svg
            //'role_id' => 'bail|required',

        ];
    }


    public static function messages()
    {
        return [
            'restaurant_name.required' => __('admin/validation/restaurant.restaurant_name.required'),
            'restaurant_bio.required' => __('admin/validation/restaurant.restaurant_bio.required'),
            'country.required' => __('admin/validation/restaurant.region.required'),
            'restaurant_phone_number.required' => __('admin/validation/restaurant.restaurant_phone_number.required'),
            'address1.required' => __('admin/validation/restaurant.restaurant_address.required'),
            'address2.required' => __('admin/validation/restaurant.restaurant_address2.required'),
            'locality.required' => __('admin/validation/restaurant.city.required'),
            'postcode.required' => __('admin/validation/restaurant.restaurant_long.required'),
            'deliverytime.required' => __('admin/validation/restaurant.deliverytime.required'),
        ];
    }


    /**
     * author : jaidev
     * email : jaidev@nmgtechnologies.com
     * desc : this rules are created to validate request from vendor panel while edit/update profile
     * methods : [vendorPanelRules , vendorPanelMessages]
     */

    public static function vendorPanelRules($id = null, $request = null)
    {
        // if()
        // dd($id);
        return [
            'name' => 'bail|required|string|max:' . config('admin.constants.restaurant.restaurant_name.maxLength'),
            'type' => 'bail|required',
            'restaurant_bio' => 'bail|required|string|max:' . config('admin.constants.restaurant.restaurant_bio.maxLength'),
            'country' => 'bail|required|string',
            // 'phone_number' => 'bail|required|string|unique:users,phone_number,'.($id ? $id : '').'|min:' .config('admin.constants.user.phone_number.minLength') .'|max:' .config('admin.constants.user.phone_number.maxLength'),
            'address1' => 'bail|required|string',
            // 'address2' => 'bail|required|string',
            'locality' => 'bail|required|string',
            //'postcode' => 'bail|required|string',
            'avatar' => 'bail|nullable|mimes:' . config('admin.constants.user.avatar.mimes') . '|max:' . config('admin.constants.user.avatar.size'), //formats: jpeg, png, bmp, gif, svg
            //'role_id' => 'bail|required',

        ];
    }
    public static function vendorPanelMessages()
    {
        return [
            'name.required' => __('admin/validation/restaurant.restaurant_name.required'),
            'name.max' => __('admin/validation/restaurant.restaurant_name.max'),

            'restaurant_bio.required' => __('admin/validation/restaurant.restaurant_bio.required'),
            'restaurant_bio.max' => __('admin/validation/restaurant.restaurant_bio.max'),

            'country.required' => __('admin/validation/restaurant.region.required'),
            'phone_number.required' => __('admin/validation/restaurant.restaurant_phone_number.required'),
            'address1.required' => __('admin/validation/restaurant.restaurant_address.required'),
            'address2.required' => __('admin/validation/restaurant.restaurant_address2.required'),
            'locality.required' => __('admin/validation/restaurant.city.required'),
            'postcode.required' => __('admin/validation/restaurant.zipcode.required'),
            'avatar.mimes' => __('admin/validation/user.avatar.mimes'),
            'avatar.max' => __('admin/validation/user.avatar.filesize'),
            'type.required' => __('admin/validation/restaurant.type.required'),

        ];
    }






    public static function signupRules($id = null)
    {
        return [
            'name' => 'bail|required|string',
            'bio' => 'bail|required|string',
            'email' => 'bail|required|string|email|max:' . config('admin.constants.user.email.maxLength') . '|unique:users,email',
            'phone_number' => 'bail|required|unique:users,phone_number|min:' . config('admin.constants.user.mobile_no.minLength') . '|max:' . config('admin.constants.user.mobile_no.maxLength'),
            'address1' => 'bail|required|string',
            'locality' => 'bail|required|string',
            'country' => 'bail|required|string',
            //'postcode' => 'bail|required|string',
            //'postcode' => 'bail|required|string',
            //'avatar' => 'bail|nullable|mimes:' . config('admin.constants.user.avatar.mimes') . '|max:' . config('admin.constants.user.avatar.size'), //formats: jpeg, png, bmp, gif, svg
            //'role_id' => 'bail|required',

        ];
    }

    public static function signupMessages()
    {
        return [
            'name.required' => __('admin/validation/restaurant.restaurant_name.required'),
            'bio.required' => __('admin/validation/restaurant.restaurant_bio.required'),
            'email.required' => __('admin/validation/restaurant.restaurant_email_id.required'),
            'phone_number.required' => __('admin/validation/restaurant.restaurant_phone_number.required'),
            'address1.required' => __('admin/validation/restaurant.restaurant_address.required'),
            'locality.required' => __('admin/validation/restaurant.city.required'),
            'country.required' => __('admin/validation/restaurant.region.required'),
            'postcode.string' => __('admin/validation/restaurant.zipcode.string'),

        ];
    }

    public function user()
    {
        return $this->belongsTo('app\Model\Admin\User', 'owner_id', 'id');
    }


    /**
     * Author: Bibhash kumar
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: list()
     * @description: This function fetches restaurent list from database.
     * return : records
     * @Created 23/June/2021
     * @Updated 23/June/2021
     */

    public function list($request)
    {
        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $search = !empty($request->search) ? $request->search : '';
        $status = $request->status != '' ? $request->status : '';

        $query = Restaurant::with('user');
        if (!empty($search)) {

            $query->where(function ($q) use ($search) {
                $q->Where('restaurants.name', 'LIKE', "%$search%");
                $q->orwhereHas('user', function ($q) use ($search) {
                    return $q->where('email', 'like', '%' . $search . '%');
                });
            });
        }
        if ($request->has('is_include_commission') && $request->is_include_commission != '') {
            $query->where('is_include_commission', $request->is_include_commission);
        }

        if ($request->has('resturent_type_local') && $request->resturent_type_local != '') {
            $query->where('resturent_type_local', $request->resturent_type_local);
        }

        if ($request->has('resturent_type_continental') && $request->resturent_type_continental != '') {
            $query->where('resturent_type_continental', $request->resturent_type_continental);
        }

        if ($request->has('resturent_type_groceries') && $request->resturent_type_groceries != '') {
            $query->where('resturent_type_groceries', $request->resturent_type_groceries);
        }
        if ($request->has('status') && $request->status != '') {
            $status = $request->status;
            $query->where(function ($q) use ($status) {
                $q->orwhereHas('user', function ($q) use ($status) {
                    return $q->where('status', $status);
                });
            });
        }

        $query->orderBy('id', 'DESC');
        $records = $query->paginate($limit);
        return $records;
    }

    /**
     * Author: Bibhash kumar
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: show()
     * @description: This function show restaurent from database.
     * return : records
     * @Created 23/June/2021
     * @Updated 24/June/2021
     */

    public function restaurantShow($id)
    {
        $query = Restaurant::with('user');
        $query->orwhereHas('user', function ($q) use ($id) {
            return $q->where('id', $id);
        });
        return $query->first();
    }

    static function getRestaurantData($id)
    {
        $query = Restaurant::with('user');
        $query->orwhereHas('user', function ($q) use ($id) {
            return $q->where('id', $id);
        });
        return $query->first();
    }


    static function getRow($ownerId)
    {
        return Restaurant::where(['owner_id' => $ownerId])->first();
    }
}
