<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;

class Permissions extends Model
{

    protected $tables = 'permissions';
    public $incrementing = false;
    protected $primaryKey = ['role_id', 'module_id'];
    protected $fillable = ['role_id', 'module_id', 'status', 'created_by', 'updated_by'];
    public $timestamps = false;

    public function modules()
    {
        return $this->belongsTo('app\Model\Admin\Modules', 'module_id', 'id');
    }

}