<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use \app\Model\Admin\User;

class Order extends Model
{

    public function user()
    {
        return $this->belongsTo('app\Model\Admin\User', 'user_id', 'id');
    }

    public function restaurant()
    {
        return $this->belongsTo('app\Model\Admin\Restaurant', 'restaurant_id', 'id')->with('user');
    }


    public function deliveryPerson()
    {
        return $this->belongsTo('app\Model\Admin\DeliveryPersons', 'delivery_person_id', 'id')->with('user');
    }

    public function orderStatus()
    {
        return $this->belongsTo('app\Model\Admin\OrderStatus', 'order_status_id', 'id');
    }
    public function orderItem()
    {
        return $this->hasMany('app\Model\Admin\OrderItem', 'order_id', 'id')->with('itemDetail');
    }

    public function transaction()
    {
        return $this->belongsTo('app\Model\Admin\Transaction', 'transaction_id', 'id');
    }

    //
    public static function list($request)
    {
        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $search = !empty($request->search) ? $request->search : '';
        $status = !empty($request->status) ? $request->status : '';
        $delivery_person_id = !empty($request->delivery_person) ? $request->delivery_person : '';
        $start_date = !empty($request->start_date) ? $request->start_date : '';
        $end_date = !empty($request->end_date) ? $request->end_date : '';
        $restaurant = !empty($request->restaurant) ? $request->restaurant : '';



        $sort = !empty($request->sort) ? $request->sort : 'created_at';
        $sortType = !empty($request->direction) ? $request->direction : 'asc';
        $query = Order::with('user')->with('restaurant')->with('deliveryPerson')->with('orderStatus');
        if (!empty($search)) {
            $query->where(function ($q) use ($search) {
                $q->where('id', 'like', '%' . $search . '%');
            });
        }
        if (!empty($status)) {
            $query->where('order_status_id', $status);
        }

        if (!empty($delivery_person_id)) {
            $query->where('delivery_person_id', $delivery_person_id);
        }

        if (!empty($restaurant)) {
            $query->where('restaurant_id', $restaurant);
        }

        if (!empty($start_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '>=', $start_date);
        }
        if (!empty($end_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '<=', $end_date);
        }

        $query->orderBy('id', 'DESC');

        $records = $query->paginate($limit);


        // dd($query->toSql());
        return $records;
    }
    public static function details($id)
    {
        // dd($request->all());

        $query = Order::where(['id' => $id])->with('user')->with('restaurant')->with('deliveryPerson')->with('orderStatus')->with('orderItem')->with('transaction');
        $data = $query->first();
        return $data;
    }




    /**
     * Author : jaidev
     * Method : restaurantOrderList
     * Desc : returns order listing according to restaurant
     * Create : 24/Jan/2022
     *
     */

    public static function restaurantOrderList($request)
    {
        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $search = !empty($request->search) ? $request->search : '';
        $restaurant = !empty($request->restaurant) ? $request->restaurant : '';
        $delivery_person_id = !empty($request->delivery_person) ? $request->delivery_person : '';
        $payment_status = (isset($request->payment_status) && $request->payment_status != '') ? $request->payment_status : '';
        $start_date = !empty($request->start_date) ? $request->start_date : '';
        $end_date = !empty($request->end_date) ? $request->end_date : '';
        // dd($payment_status);

        $sort = !empty($request->sort) ? $request->sort : 'created_at';
        $sortType = !empty($request->direction) ? $request->direction : 'asc';
        $query = Order::where(['order_status_id' => config('admin.constants.ORDER_STATUS_COMPLETED')])->with('user')->with('restaurant')->with('deliveryPerson')->with('orderStatus');
        if (!empty($search)) {
            $query->where(function ($q) use ($search) {
                $q->where('id', 'like', '%' . $search . '%');
            });
        }
        if (!empty($restaurant)) {
            $query->where('restaurant_id', $restaurant);
        }

        if (!empty($delivery_person_id)) {
            $query->where('delivery_person_id', $delivery_person_id);
        }

        if ($payment_status != '') {
            $query->where('vendor_payment_status', $payment_status);
        }

        if (!empty($start_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '>=', $start_date);
        }
        if (!empty($end_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '<=', $end_date);
        }

        $query->orderBy('id', 'DESC');
        $records = $query->paginate($limit);
        return $records;
    }


    /**
     * Author : jaidev
     * Method : riderOrderList
     * Desc : returns order listing according to rider
     * Create : 24/Jan/2022
     *
     */

    public static function riderOrderList($request)
    {
        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $search = !empty($request->search) ? $request->search : '';
        $rider = !empty($request->rider) ? $request->rider : '';
        $delivery_person_id = !empty($request->delivery_person) ? $request->delivery_person : '';
        $payment_status = (isset($request->payment_status) && $request->payment_status != '') ? $request->payment_status : '';
        $start_date = !empty($request->start_date) ? $request->start_date : '';
        $end_date = !empty($request->end_date) ? $request->end_date : '';

        $sort = !empty($request->sort) ? $request->sort : 'created_at';
        $sortType = !empty($request->direction) ? $request->direction : 'asc';
        $query = Order::where(['order_status_id' => config('admin.constants.ORDER_STATUS_COMPLETED')])->with('user')->with('restaurant')->with('deliveryPerson')->with('orderStatus');
        if (!empty($search)) {
            $query->where(function ($q) use ($search) {
                $q->where('id', 'like', '%' . $search . '%');
            });
        }
        if (!empty($rider)) {
            $query->where('delivery_person_id', $rider);
        }

        if (!empty($delivery_person_id)) {
            $query->where('delivery_person_id', $delivery_person_id);
        }

        if ($payment_status != '') {
            $query->where('rider_payment_status', $payment_status);
        }

        if (!empty($start_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '>=', $start_date);
        }
        if (!empty($end_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '<=', $end_date);
        }
        $query->orderBy('id', 'DESC');
        $records = $query->paginate($limit);
        return $records;
    }


    /**
     * Author : Jaidev
     * Date : 10/May/2022
     * Method :
     * Desc : return payment amount summary
     */

    public static function getRiderPaymentSummary($request)
    {
        // get sum of total amount which is paid & un-paid
        // dd($request);
        $rider = !empty($request->rider) ? $request->rider : '';
        $search = !empty($request->search) ? $request->search : '';
        $start_date = !empty($request->start_date) ? $request->start_date : '';
        $end_date = !empty($request->end_date) ? $request->end_date : '';


        if (!empty($rider)) {
            $wh['delivery_person_id'] = $rider;
        }
        $wh['order_status_id'] = config('admin.constants.ORDER_STATUS_COMPLETED');
        $query = Order::select('rider_payment_status', \DB::raw('SUM(delivery_person_revenue) AS subTotal'))
            ->where($wh);

        if (!empty($search)) {
            $query->where('id', 'like', '%' . $search . '%');
        }
        if (!empty($start_date)) {
            $query->where(\DB::raw('DATE_FORMAT(created_at , "%Y-%m-%d")'), '>=', $start_date);
        }

        if (!empty($end_date)) {
            $query->where(\DB::raw('DATE_FORMAT(created_at , "%Y-%m-%d")'), '<=', $end_date);
        }

        return $query->groupBy('rider_payment_status')->get()->pluck('subTotal', 'rider_payment_status');
    }
}
