<?php

namespace app\Model\Admin;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{

    protected $tables   = 'notifications';
    protected $hidden   = [];
    protected $fillable = [];
    protected $guarded  = [];


    public function user()
    {
        return $this->hasOne('app\Model\Admin\User', 'id', 'user_id');
    }

    public function restaurant()
    {
        return $this->hasOne('app\Model\Admin\Restaurant', 'owner_id', 'user_id');
    }

    public static function unreadCount($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }

        $total = 0;
        $total = self::where([
            ['user_id', '=', $user_id],
            ['is_read', '=', 0],
        ])->get()
            ->count();

        return $total;
    }

    public function list($request)
    {
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $query = $this->query()->with('user')->with('restaurant');


        $search = !empty($request->search) ? $request->search : '';
        $start_date = !empty($request->start_date) ? $request->start_date : '';
        $end_date = !empty($request->end_date) ? $request->end_date : '';


        if (!empty($search)) {

            $query->where(function ($q) use ($search) {
                $q->where('order_id', 'like', '%' . $search . '%');
                $q->orwhereHas('restaurant', function ($q) use ($search) {
                    return $q->where('name', 'like', '%' . $search . '%');
                });

                $q->orwhereHas('user', function ($q) use ($search) {
                    $q->where('phone_number', 'like', '%' . $search . '%');
                    $q->where('email', 'like', '%' . $search . '%');
                    $q->where('first_name', 'like', '%' . $search . '%');
                    $q->where('last_name', 'like', '%' . $search . '%');
                    return $q;
                });

                $q->orwhereHas('user', function ($q) use ($search) {
                    return $q->where(DB::raw('concat(first_name , " " , last_name)'), 'like', '%' . $search . '%');
                });
            });
        }

        if (!empty($start_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '>=', $start_date);
        }
        if (!empty($end_date)) {
            $query->where(\DB::raw('date_format(created_at ,  "%Y-%m-%d")'), '<=', $end_date);
        }

        $query->when(isset($request->userId), function ($q) use ($request) {
            return $q->where('user_id', $request->userId);
        });
        $query->orderBy('id', 'desc');
        return $query->paginate($limit);
    }
}
