<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class Modules extends Model
{

    use Sortable;

    public $sortable = ['id', 'name', 'title', 'parent_id', 'controller', 'action', 'status'];
    protected $tables = 'modules';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['name', 'title', 'parent_id', 'controller', 'action', 'path', 'icon_class', 'is_display_menu', 'status'];

    // @Author: KS.
    // @description : Below function uses for server validation
    // @return \Illuminate\Http\Response

    public function rules($id = null)
    {
        return [
            'title' => 'required|max:255',
            'controller' => 'required',
            'action' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'title.required' => 'Please enter title.',
            'controller.required' => 'Please enter controller name.',
            'action.required' => 'Please enter action.',
        ];
    }

    /**
     * Get the index name for the model.
     *
     * @return string
     */
    public function children()
    {
        return $this->hasMany('app\Model\Admin\Modules', 'parent_id', 'id')->orderBy('sort_order', 'ASC');
    }

    // @Author: KS.
    // @description : Below function uses for return categoryList
    // @return \Illuminate\Http\Response

    public static function fetchModuleList($roleId)
    {
        //$pageSize = config('admin.constants.AdminPageSize');
        //$search = !empty($request->search) ? $request->search : '';
        $query = Modules::with([
            'getPermissions' => function ($q) use ($roleId) {
                return $q->where('role_id', $roleId);
            },
            'children.getPermissions' => function ($q) use ($roleId) {
                return $q->where('role_id', $roleId);
            },
            'children.children.getPermissions' => function ($q) use ($roleId) {
                return $q->where('role_id', $roleId);
            },
        ])->where('status', '=', 1)->where('parent_id', '=', 0)->orderBy('sort_order', 'ASC');
        // if(!empty($search)) {
        //     $query->whereRaw(\DB::raw('(title like "%' . $search . '%")'));
        // }
        //$modules = $query->sortable(['id' => 'desc'])->paginate($pageSize);
        $modules = $query->get();
        return $modules;
    }

    public static function getChildrenList($roleId)
    {
        $modules = self::fetchModuleList($roleId);
        foreach ($modules as $module) {
            $module->text = $module->title;
            $module->checked = (isset($module->getPermissions[0]) && $module->getPermissions[0]->status) ? true : false;
            unset($module->getPermissions);
            if (count($module->children)) {
                foreach ($module->children as $child) {
                    $child->text = $child->title;
                    $child->checked = (isset($child->getPermissions[0]) && $child->getPermissions[0]->status) ? true : false;
                    unset($child->getPermissions);
                    if (count($child->children)) {
                        foreach ($child->children as $childNextLevel) {
                            $childNextLevel->text = $childNextLevel->title;
                            $childNextLevel->checked = (isset($childNextLevel->getPermissions[0]) && $childNextLevel->getPermissions[0]->status) ? true : false;
                            unset($childNextLevel->getPermissions);
                        }
                    }
                }
            }
        }
        return $modules;
    }

    public function fetchMenuList($roleId)
    {

        $query = Modules::with([
            'getPermissions' => function ($q) use ($roleId) {
                return $q->where('role_id', $roleId);
            },
            'children' => function ($q) {
                return $q->where('is_display_menu', 1);
            },
            'children.getPermissions' => function ($q) use ($roleId) {
                return $q->where('role_id', $roleId);
            },
            'children.children' => function ($q) {
                return $q->where('is_display_menu', 1);
            },
            'children.children.getPermissions' => function ($q) use ($roleId) {
                return $q->where('role_id', $roleId);
            },
        ])->where('status', '=', 1)->where('parent_id', '=', 0)->where('is_display_menu', 1)->orderBy('sort_order', 'ASC');
        $modules = $query->get();
        return $modules;
    }

    public function getPermissions()
    {

        return $this->hasMany('app\Model\Admin\Permissions', 'module_id', 'id');
    }

}
