<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;

class InstantMail extends Model
{
    const UPDATED_AT = null;

    protected $tables = 'instant_mails';
    protected $hidden = ['created_at'];
    protected $fillable = ['type', 'role_id', 'facility_id', 'user_id', 'email', 'subject', 'content', 'push_title', 'push_content', 'created_by', 'created_at'];
    protected $guarded = [];

    public static function rules($id = null)
    {
        return [
           // 'role_id' => 'bail|nullable|exists:roles,id',
            //'email' => 'bail|nullable|required_if:type,single|email|exists:users,email',
            'email' => 'bail|nullable|required_if:type,single|emails',
            'subject' => 'bail|required_with:content,|max:' . config('admin.constants.mailbox.subject.maxLength'),
            'content' => 'bail|required_with:subject,',
          //  'push_title' => 'bail|required_with:push_content,|max:' . config('admin.constants.mailbox.push_title.maxLength'),
           // 'push_content' => 'bail|required_with:push_title,|max:' . config('admin.constants.mailbox.push_content.maxLength'),
        ];
    }

    public static function messages()
    {
        return [
            'role_id.required' => __('admin/validation/mailbox.role_id.required'),
            'role_id.required_if' => __('admin/validation/mailbox.role_id.required_if'),
            'role_id.exists' => __('admin/validation/mailbox.role_id.exists'),

            'email.required' => __('admin/validation/mailbox.email.required'),
            'email.required_if' => __('admin/validation/mailbox.email.required_if'),
            'email.email' => __('admin/validation/mailbox.email.email'),
            'email.exists' => __('admin/validation/mailbox.email.exists'),

            'subject.required' => __('admin/validation/mailbox.subject.required'),
            'subject.required_with' => __('admin/validation/mailbox.subject.required_with'),
            'subject.max' => __('admin/validation/mailbox.subject.max'),

            'content.required' => __('admin/validation/mailbox.content.required'),
            'content.required_with' => __('admin/validation/mailbox.content.required_with'),

            'push_title.required' => __('admin/validation/mailbox.push_title.required'),
            'push_title.required_with' => __('admin/validation/mailbox.push_title.required_with'),
            'push_title.max' => __('admin/validation/mailbox.push_title.max'),

            'push_content.required' => __('admin/validation/mailbox.push_content.required'),
            'push_content.required_with' => __('admin/validation/mailbox.push_content.required_with'),
            'push_content.max' => __('admin/validation/mailbox.push_content.max'),
        ];
    }
}
