<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class GlobalSetting extends Model {

    use Sortable;

    public $sortable = ['id', 'reference', 'datatype', 'created_at'];
    protected $tables = 'global_settings';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['id', 'slug', 'datatype', 'value', 'status', 'created_at', 'updated_at'];

    public static function rules($id = null) {
        return [
            'value' => 'bail|required|string|min:' . config('admin.constants.global-setting.value.minLength') . '|max:' . config('admin.constants.global-setting.value.maxLength'),
        ];
    }

    public static function messages() {
        return [
            'value.required' => __('admin/validation/global-setting.value.required'),
            'value.min' => __('admin/validation/global-setting.value.min'),
            'value.max' => __('admin/validation/global-setting.value.max'),
        ];
    }

}
