<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;

class GeneralSetting extends Model
{

    /**
     * Author: Bibhash
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: taxCharge()
     * @returns: A Row return of tax charges for admin
     * @Description: This function fetches  admin tax from database, sets up
     *  breadcrumb & other constants.
     * @Created 21/June/2021
     * @Updated 21/June/2021
     */

    public function taxCharge($request)
    {

        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        /*$this->const['page'] = $page;*/
        $limit = $request->limit;
        return $query = GeneralSetting::select('*')->where('id', 2)->first();
    }

    /**
     * Author: Bibhash
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: deliveryCharge()
     * @returns: A Row return of delivery charges for admin
     * @Description: This function fetches delivery charges from database, sets up
     *  breadcrumb & other constants.
     * @Created 21/June/2021
     * @Updated 21/June/2021
     */

    public static function deliveryCharge($request)
    {

        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        /*$this->const['page'] = $page;*/
        $limit = $request->limit;
        return $query = GeneralSetting::select('*')->whereIn('id', [3, 4, 5, 6, 7, 8])->get();
    }

    /**
     * Author: Bibhash
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: commission()
     * @returns: A Row return of commission charges for admin
     * @Description: This function fetches  admin commission from database, sets up
     *  breadcrumb & other constants.
     * @Created 21/June/2021
     * @Updated 21/June/2021
     */

    public function commission($request)
    {

        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        /*$this->const['page'] = $page;*/
        $limit = $request->limit;
        return $query = GeneralSetting::select('*')->where('id', 1)->first();
    }

    /**
     * Author: Bibhash
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: activeInactiveAction()
     * @returns:
     * @Description: This function update active inactive delivery charges setting into database.
     * @Created 21/June/2021
     * @Updated 21/June/2021
     */

    static public function activeInactiveAction($id, $request)
    {
        $deliveryCharge = GeneralSetting::find($id);
        $deliveryCharge->value = $request->delivery_charge;
        $deliveryCharge->status = $request->status;
        $recdUpdated = $deliveryCharge->save();

        return true;
    }



    public static function getDeliveryCharges()
    {
        $data = GeneralSetting::where(['slug' => 'delivery_charges', 'status' => 1])->first();
        if ($data) {
            return (float) $data->value;
        } else {
            return null;
        }
    }

    public static function getMileCharges()
    {
        $data = GeneralSetting::where(['slug' => 'per_mile_charges', 'status' => 1])->first();
        if ($data) {
            return (float) $data->value;
        } else {
            return null;
        }
    }

    public static function getDeliveryRange()
    {
        $data = GeneralSetting::where(['slug' => 'delivery_range', 'status' => 1])->first();
        if ($data) {
            return (float) $data->value;
        } else {
            return null;
        }
    }

    public static function getTaxFee()
    {
        $data = GeneralSetting::where(['slug' => 'tax_fee', 'status' => 1])->first();
        if ($data) {
            return $data->value;
        } else {
            return null;
        }
    }


    public static function getTaxableAmount($amount)
    {
        $data = GeneralSetting::where(['slug' => 'tax_fee', 'status' => 1])->first();
        if ($data) {
            if ($data->symbal == 'fixed') {
                return $data->value;
            } else {
                return (($amount * $data->value) / 100);
            }
        } else {
            return null;
        }
    }


    public static function getCommissionPerc()
    {
        $data = GeneralSetting::where(['slug' => 'commission_service_fee', 'status' => 1])->first();
        if ($data) {
            return (float) $data->value;
        } else {
            return null;
        }
    }

    public static function riderFixedDeliveryFee()
    {
        $data = GeneralSetting::where(['slug' => 'delivery_fee_rider', 'status' => 1])->first();
        if ($data) {
            return (float) $data->value;
        } else {
            return null;
        }
    }

    public static function pencePerMile()
    {
        $data = GeneralSetting::where(['slug' => 'pence_per_mile', 'status' => 1])->first();
        if ($data) {
            return (float) $data->value;
        } else {
            return null;
        }
    }

    public static function dcApplicableAfter()
    {
        $data = GeneralSetting::where(['slug' => 'per_mile_charge_applicable_after', 'status' => 1])->first();
        if ($data) {
            return (float) $data->value;
        } else {
            return null;
        }
    }
}
