<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class EmailType extends Model {

    use Sortable;

    public $sortable = ['id', 'name', 'slug'];
    protected $tables = 'email_types';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['slug', 'name', 'created_at', 'updated_at'];

    //@author:Rahul
    //@description: To fetch all email types used in edit email templates
    //@param  null
    //return : all roles except Super_admin
    public static function fetchAllTypes() {
        return Self::select('id', 'name')->get()->pluck('name', 'id');
    }

}
