<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class EmailTemplate extends Model {

    use Sortable;

    public $sortable = ['id', 'email_type_id', 'locale', 'subject', 'content'];
    protected $tables = 'email_templates';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['email_type_id', 'locale', 'subject', 'content', 'status', 'created_at', 'updated_at'];

    public static function rules($id = null)
    {
        return [
            'subject' => 'bail|required|string|min:' . config('admin.constants.email-template.subject.minLength') . '|max:' . config('admin.constants.email-template.subject.maxLength'),
            'content' => 'bail|required|string|min:' . config('admin.constants.email-template.content.minLength'),
            //'content' => 'bail|required|string|min:' . config('admin.constants.email-template.content.minLength') .'|max:' . config('admin.constants.email-template.content.maxLength'),
        ];
    }

    public static function messages()
    {
        return [
            'subject.required' => __('admin/validation/email-template.subject.required'),
            'subject.min' => __('admin/validation/email-template.subject.min'),
            'subject.max' => __('admin/validation/email-template.subject.max'),

            'content.required' => __('admin/validation/email-template.content.required'),
            'content.min' => __('admin/validation/email-template.content.min'),
            'content.max' => __('admin/validation/email-template.content.max'),
        ];
    }

    public function fetchEmailTemplateBySlug($slug = null) {
        
        if (!empty($slug)) {
            $locale = \App::getLocale();
            $query = EmailTemplate::leftjoin('email_types', 'email_templates.email_type_id', '=', 'email_types.id')
                    ->where(function($query) use ($slug, $locale) {
                        $query->Where('email_types.slug', '=', "$slug")
                        ->Where('email_templates.locale', '=', "$locale")
                        ->Where('email_templates.status', '=', "1");
                    })
                    ->select('email_templates.subject', 'email_templates.content');

            $emailTemplate = $query->first();
            
            if (!empty($emailTemplate))
                $emailTemplate = $emailTemplate->toArray();

            return $emailTemplate;
        }
        return false;
    }

    public function emailType() {
        //return $this->belongsTo('app\Model\Admin\EmailType', 'email_type_id', 'id');
        return $this->belongsTo('app\Model\Admin\EmailType')->latest();
    }

}
