<?php

namespace app\Model\Admin;

use app\Model\Api\V1\DeliveryPerson;
use Illuminate\Database\Eloquent\Model;
use app\Traits\FilePathUrl;
use File;
use Image;
use Kyslik\ColumnSortable\Sortable;
use Illuminate\Support\Facades\DB;


class DeliveryPersons extends Model
{
    use FilePathUrl;
    use Sortable;


    protected $tables = 'delivery_persons';
    //protected $hidden = ['created_at', 'updated_at'];
    protected $guarded = [];
    public $sortable = ['users.username',   'users.email', 'users.phone_number', 'delivery_person.'];


    public static function rules($id = null)
    {
        if ($id) {
            $data = DeliveryPersons::where(['id' => $id])->first();
        }
        return [
            // 'user_name' => 'bail|required|string|min:' . config('admin.constants.user.user_name.minLength') . '|max:' . config('admin.constants.user.user_name.maxLength') . ($id ? $id : ''),
            // 'email' => 'bail|required|string|email|max:' . config('admin.constants.user.email.maxLength')  . ($id ? $id : ''),
            'phone_number' => 'bail|required|unique:users,phone_number,' . ($id ? $data->user_id : '') . '|min:' . config('admin.constants.user.phone_number.minLength') . '|max:' . config('admin.constants.user.phone_number.maxLength'),
            'first_name' => 'bail|required|string|min:' . config('admin.constants.user.first_name.minLength') . '|max:' . config('admin.constants.user.first_name.maxLength'),
            'last_name' => 'bail|required|string|min:' . config('admin.constants.user.last_name.minLength') . '|max:' . config('admin.constants.user.last_name.maxLength'),
            'avatar' => 'bail|nullable|mimes:' . config('admin.constants.user.avatar.mimes') . '|max:' . config('admin.constants.user.avatar.size'), //formats: jpeg, png, bmp, gif, svg
            //'role_id' => 'bail|required',
            'age' => 'bail|required|string|min:' . config('admin.constants.delivery-person.age.minLength') . '|max:' . config('admin.constants.delivery-person.age.maxLength'),
            'id_proof' => 'bail|nullable|mimes:' . config('admin.constants.user.doc.mimes') . '|max:' . config('admin.constants.user.doc.size'), //formats: jpeg, png, bmp, gif, svg
            'vehicle_info' => 'bail|nullable|mimes:' . config('admin.constants.user.doc.mimes') . '|max:' . config('admin.constants.user.doc.size'), //formats: jpeg, png, bmp, gif, svg
            'driving_license' => 'bail|nullable|mimes:' . config('admin.constants.user.doc.mimes') . '|max:' . config('admin.constants.user.doc.size'), //formats: jpeg, png, bmp, gif, svg
            //'vehicle_info' => 'bail|required|string|min:' . config('admin.constants.delivery-person.vehicle_info.minLength'),
            //'driving_license' => 'bail|required|string|min:' . config('admin.constants.delivery-person.driving_license.minLength'),
            'account_number' => 'bail|required|string|min:' . config('admin.constants.delivery-person.account_number.minLength'),
            'bank_name' => 'bail|required|string|min:' . config('admin.constants.delivery-person.bank_name.minLength'),
        ];
    }


    public static function messages()
    {
        return [
            'role_id.required' => __('admin/validation/user.role_id.required'),
            'user_name.required' => __('admin/validation/user.user_name.required'),
            'user_name.string' => __('admin/validation/user.user_name.string'),
            'user_name.min' => __('admin/validation/user.user_name.min'),
            'user_name.max' => __('admin/validation/user.user_name.max'),
            'user_name.regex' => __('admin/validation/user.user_name.regex'),
            'email.required' => __('admin/validation/user.email.required'),
            'email.string' => __('admin/validation/user.email.max'),
            'email.email' => __('admin/validation/user.email.min'),
            'email.max' => __('admin/validation/user.email.max'),
            'email.unique' => __('admin/validation/user.email.unique'),
            'email.exists' => __('admin/validation/user.email.exists'),
            'mobile_no.required' => __('admin/validation/user.mobile_no.required'),
            'mobile_no.min' => __('admin/validation/user.mobile_no.min'),
            'mobile_no.max' => __('admin/validation/user.mobile_no.max'),
            'password.required' => __('admin/validation/user.password.required'),
            'password.string' => __('admin/validation/user.password.string'),
            'password.min' => __('admin/validation/user.password.min'),
            'password.max' => __('admin/validation/user.password.max'),
            'password.regex' => __('admin/validation/user.password.regex'),
            'new_password.required' => __('admin/validation/user.new_password.required'),
            'new_password.string' => __('admin/validation/user.new_password.string'),
            'new_password.min' => __('admin/validation/user.new_password.min'),
            'new_password.max' => __('admin/validation/user.new_password.max'),
            'new_password.regex' => __('admin/validation/user.new_password.regex'),
            'new_password.different' => __('admin/validation/user.new_password.different'),
            'new_password.confirmed' => __('admin/validation/user.new_password.confirmed'),
            'new_password_confirmation.required' => __('admin/validation/user.new_password_confirmation.required'),
            'token.required' => __('admin/validation/user.token.required'),
            'first_name.required' => __('admin/validation/user.first_name.required'),
            'first_name.string' => __('admin/validation/user.first_name.string'),
            'first_name.min' => __('admin/validation/user.first_name.min'),
            'first_name.max' => __('admin/validation/user.first_name.max'),
            'first_name.regex' => __('admin/validation/user.first_name.regex'),
            'last_name.required' => __('admin/validation/user.last_name.required'),
            'last_name.string' => __('admin/validation/user.last_name.string'),
            'last_name.min' => __('admin/validation/user.last_name.min'),
            'last_name.max' => __('admin/validation/user.last_name.max'),
            'last_name.regex' => __('admin/validation/user.last_name.regex'),

            'age.required' => __('admin/validation/delivery-person.age.required'),
            'age.min' => __('admin/validation/delivery-person.age.min'),
            'age.max' => __('admin/validation/delivery-person.age.max'),
            'age.regex' => __('admin/validation/delivery-person.age.regex'),

            'account_details.required' => __('admin/validation/delivery-person.account_details.required'),
            'account_details.min' => __('admin/validation/delivery-person.account_details.min'),
            'account_details.regex' => __('admin/validation/delivery-person.account_details.regex'),

            'id_proof.mimes' => __('admin/validation/user.avatar.mimes'),
            'id_proof.max' => __('admin/validation/user.avatar.filesize'),

            'vehicle_info.mimes' => __('admin/validation/user.avatar.mimes'),
            'vehicle_info.max' => __('admin/validation/user.avatar.filesize'),

            'driving_license.mimes' => __('admin/validation/user.avatar.mimes'),
            'driving_license.max' => __('admin/validation/user.avatar.filesize'),


            'avatar.mimes' => __('admin/validation/user.avatar.mimes'),
            'avatar.max' => __('admin/validation/user.avatar.filesize'),
        ];
    }

    public function user()
    {
        return $this->belongsTo('app\Model\Admin\User', 'user_id', 'id');
    }


    /**
     * records listing for Delivery Persons
     *
     * @param [type] $request
     * @return void
     */



    static function list($request)
    {
        //  dd($request->all());
        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $search = !empty($request->search) ? $request->search : '';
        $status = !empty($request->status) ? $request->status : '';
        $rider_id = !empty($request->rider_id) ? $request->rider_id : '';
        $sort = !empty($request->sort) ? $request->sort : 'created_at';
        $sortType = !empty($request->direction) ? $request->direction : 'asc';
        $query = DeliveryPersons::with('user');
        if (!empty($search)) {

            $query->where(function ($q) use ($search) {
                $q->orwhereHas('user', function ($q) use ($search) {
                    return $q->where('email', 'like', '%' . $search . '%');
                });

                $q->orwhereHas('user', function ($q) use ($search) {
                    return $q->where('phone_number', 'like', '%' . $search . '%');
                });

                $q->orwhereHas('user', function ($q) use ($search) {
                    return $q->where(DB::raw('concat(first_name , " " , last_name)'), 'like', '%' . $search . '%');
                });
            });
        }
        if (!empty($status)) {

            $query->where(function ($q) use ($status) {
                $q->orwhereHas('user', function ($q) use ($status) {
                    return $q->where('status', $status);
                });
            });
        }

        if (!empty($rider_id)) {

            $query->where('id', $rider_id);
        }

        $query->orderBy('id', 'DESC');

        $records = $query->paginate($limit);
        return $records;
    }

    public static function upload_doc($file = [], $user_id = null, $f = null)
    {

        if (empty($file) || empty($user_id)) {
            return false;
        }

        $uploaded = false;
        $uploadDir = config('admin.path.UPLOAD_DIR');
        $avatarDir = config('admin.path.avatar.DELIVERYP_DOC_DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.avatar.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.avatar.THUMB_PREFIX');

        // getting image extension
        $ext = $file->getClientOriginalExtension();
        if (empty($ext)) {
            $mime = File::mimeType($file);
            if ($mime == 'image/jpeg') {
                $ext = 'jpeg';
            }
            if ($mime == 'image/png') {
                $ext = 'png';
            }
            if ($mime == 'image/gif') {
                $ext = 'gif';
            }
            if ($mime == 'image/svg+xml') {
                $ext = 'svg';
            }
            if ($mime == 'application/pdf') {
                $ext = 'pdf';
            }
        }
        //rename image
        $fileName = uniqid() . '.' . $ext;
        if ($ext == 'pdf') {
            $imageObj = $file->getRealPath();
            $aspectByWidth = true;
            $aspectByHeight = false;
        } else {
            // die('else');
            $aspectByWidth = true;
            $aspectByHeight = false;
            $imageObj = Image::make($file->getRealPath());
            //identify greater dimension
            $initialWidth = $imageObj->width();
            $initialHeight = $imageObj->height();
            // die('sdf');
            if ($initialWidth < $initialHeight) {
                $aspectByHeight = true;
                $aspectByWidth = false;
            }
        }

        // dd($aspectByWidth);
        // check if image uploaded on aws s3
        if (env('S3_ENABLED') == true) {

            //unlink old image
            $fileDir = $uploadDir . '/' . $avatarDir . '/' . $user_id . '/';
            \app\Helpers\CommonHelper::unlinkOldImage('users', $user_id, $fileDir);

            //Original image
            $originalFile = $uploadDir . '/' . $avatarDir . '/' . $user_id . '/' . $fileName;

            $uploaded = \Storage::disk('s3')->put(
                $originalFile,
                file_get_contents($file),
                'public'
            );

            $originalUrl = self::s3Uri($originalFile);
        } else {
            $basePath = storage_path('app/public') . '/' . $uploadDir . '/' . $avatarDir . '/' . $user_id . '/';
            // create directory
            if (!File::exists($basePath)) {
                File::makeDirectory($basePath, 0755, true);
            }
            //origional image
            $uploaded = $file->move($basePath, $fileName);
            //resized image
            $fileResize = config('admin.path.avatar.RESIZE');
            if ($fileResize && $uploaded) {
                if ($aspectByWidth) {
                    $resizeWidth = config('admin.path.avatar.RESIZE_WIDTH');
                    $resizeHeight = null;
                }
                if ($aspectByHeight) {
                    $resizeHeight = config('admin.path.avatar.RESIZE_HEIGHT');
                    $resizeWidth = null;
                }
                if ($ext != 'pdf') {
                    $imageObj->resize($resizeWidth, $resizeHeight, function ($constraint) {
                        $constraint->aspectRatio();
                    })->save($basePath . $resizedPrefix . '_' . $fileName, 100);
                }
            }
            //thumb image
            $isThumb = config('admin.path.avatar.THUMB');
            if ($isThumb && $uploaded) {
                if ($aspectByWidth) {
                    $thumbWidth = config('admin.path.avatar.THUMB_WIDTH');
                    $thumbHeight = null;
                }
                if ($aspectByHeight) {
                    $thumbHeight = config('admin.path.avatar.THUMB_HEIGHT');
                    $thumbWidth = null;
                }
                if ($ext != 'pdf') {
                    $imageObj->resize($resizeWidth, $resizeHeight, function ($constraint) {
                        $constraint->aspectRatio();
                    })->save($basePath . $resizedPrefix . '_' . $fileName, 100);
                }
            }
            $originalUrl = url('/storage/app/public') . '/' . $uploadDir . '/' . $avatarDir . '/' . $user_id . '/' . $fileName;
        }

        //return response
        if ($uploaded) {

            $deliveryp_doc = DeliveryPersons::find($user_id);
            $deliveryp_doc->$f = $originalUrl;
            $deliveryp_doc->save();
            // dd($originalUrl);
            return true;
        }
        return false;
    }



    public static function pluckList($isApproved = 1)
    {
        $query =  DeliveryPersons::select([DB::raw("CONCAT(users.first_name,' ',users.last_name) AS name"),  'delivery_persons.id']);

        if ($isApproved) {
            $query->where(['is_approved' => $isApproved]);
        }
        return $query->orderBy('name', 'asc')
            ->leftJoin('users', 'users.id', 'delivery_persons.user_id')
            ->pluck('name', 'id')
            ->toArray();
    }
}
