<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Customer extends Model
{
    /**
     * show records for customer
     *
     * @param [type] $request
     * @return void
     */

    function customer($id)
    {
        $user = User::select(
            'users.id',
            'users.first_name',
            'users.last_name',
            'users.user_name',
            'users.email',
            'users.phone_number',
            'users.profile_image',
            'users.created_at',
            'users.status'
        )
            ->where('id', $id)
            ->with([
                'latestAvatar' => function ($query) {
                    $query->select('id', 'user_id', 'avatar');
                }
            ])
            ->first();
        return $user;
    }





    /**
     * fetch customer records for listing
     *
     * @param [type] $request
     * @return void
     */

    public function list($request)
    {

        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        /*$this->const['page'] = $page;*/
        //$limit = $request->limit;
        $roleId = config('admin.constants.PUBLIC_USERS_ROLE');

        $search = !empty($request->search) ? $request->search : '';
        //echo "====".$search; exit;
        $query = User::select(
            'users.id',
            'users.first_name',
            'users.last_name',
            'users.user_name',
            'users.email',
            'users.phone_number',
            'users.profile_image',
            'users.email_verified_at',
            'users.status',
            'users.created_at'
        )
            ->with([
                'latestAvatar' => function ($query) {
                    $query->select('id', 'user_id', 'avatar');
                }
            ])
            ->where('users.role_id', $roleId);
        if (!empty($search)) {

            $query->where(function ($q) use ($search) {
                $q->where('users.email', 'LIKE', "%$search%");
                $q->orWhere('users.phone_number', 'LIKE', "%$search%");
                $q->orWhere('users.first_name', 'like', "%{$search}%");
                $q->orWhere('users.last_name', 'like', "%{$search}%");
                $q->orWhere(DB::raw('concat(first_name , " " , last_name)'), 'like', '%' . $search . '%');
            });
        }
        $users = $query->sortable(['created_at' => 'desc'])->paginate($limit);

        return $users;
    }
}
