<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;

class ContactTitle extends Model
{
    protected $tables = 'contact_titles';
    protected $fillable = ['id', 'name', 'status'];

    public static function rules($id = null)
    {
        return [
            'name' => 'bail|required|string|unique:contact_titles,name,' . ($id ? $id : ''),

        ];
    }

    public static function messages()
    {
        return [
            'name.required' => __('admin/validation/contact-title.name.required'),
            'name.string' => __('admin/validation/contact-title.name.string'),
            'name.unique' => __('admin/validation/contact-title.name.unique'),
        ];
    }


    function title($request)
    {

        $page = $request->query('page', 1);
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $limit = $request->limit;
        $search = !empty($request->search) ? $request->search : '';
        $query = ContactTitle::select('id', 'name', 'status');
        if (!empty($search)) {

            $query->where(function ($q) use ($search) {
                $q->orWhere('name', 'LIKE', "%$search%");
            });
        }
        $query->orderBy('id', 'DESC');
        $users = $query->paginate($limit);
        return $users;
    }
}