<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class ContactSupport extends Model
{
    const UPDATED_AT = null;

    use Sortable;

    protected $tables = 'contact_supports';
    protected $hidden = ['created_at'];
    protected $fillable = ['user_id', 'message', 'title_id', 'created_at'];
    public $sortable = ['id', 'user_id', 'title_id', 'created_at'];
    protected $guarded = [];

    public function users()
    {
        return $this->belongsTo('app\Model\Admin\User', 'user_id', 'id')->with('restaurant');
    }

    public function restaurant()
    {
        return $this->belongsTo('app\Model\Admin\Restaurant', 'user_id', 'owner_id');
    }

    public function title()
    {
        return $this->belongsTo('app\Model\Admin\ContactTitle', 'title_id', 'id');
    }


    public static function rules($id = null)
    {
        if ($id) {
            $data = DeliveryPersons::where(['id' => $id])->first();
        }
        return [
            'title_id' => 'bail|required|string|exists:contact_titles,id',
            'message' => 'bail|required|string|min:' . config('admin.constants.contact-us.message.minLength') . '|max:' . config('admin.constants.contact-us.message.maxLength'),
        ];
    }


    public static function messages()
    {
        return [
            'title.required' => __('admin/validation/contact-us.title.required'),
            'message.required' => __('admin/validation/contact-us.message.required'),
            'title.string' => __('admin/validation/contact-us.title.string'),
            'title.min' => __('admin/validation/contact-us.title.min'),
            'title.max' => __('admin/validation/contact-us.title.max'),
            'message.required' => __('admin/validation/contact-us.message.required'),
            'message.string' => __('admin/validation/contact-us.message.max'),
            'message.email' => __('admin/validation/contact-us.message.min'),
            'message.max' => __('admin/validation/contact-us.message.max'),
        ];
    }
}