<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class BlockedUser extends Model
{
    use Sortable;

    protected $tables = 'blocked_users';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['id', 'user_id', 'blocked_by', 'status', 'blocked_reason_id'];
    public $sortable = ['id', 'user_id', 'blocked_by', 'blocked_reason_id'];

    public function blockedReason()
    {

        return $this->belongsTo('app\Model\Admin\BlockedReason');
    }

    public function blockedBy()
    {

        return $this->belongsTo('app\Model\Admin\User', 'blocked_by', 'id');
    }

    public function users()
    {

        return $this->belongsTo('app\Model\Admin\User', 'user_id', 'id');
    }
}