<?php

namespace app\Model\Admin;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class BlockedReason extends Model
{
    use Sortable;

    protected $tables = 'blocked_reasons';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['id', 'reason', 'status'];
    public $sortable = ['id', 'reason'];

    public static function rules($id = null)
    {
        return [
            'reason' => 'required|unique:blocked_reasons,reason,' . ($id ? $id : '') . '|min:' . config('admin.constants.blocked-reason.reason.minLength'). '|max:' . config('admin.constants.blocked-reason.reason.maxLength'),
        ];
    }

    public static function messages()
    {
        return [
            'reason.required' => __('admin/validation/blocked-reason.reason.required'),
            'reason.min' => __('admin/validation/blocked-reason.reason.min'),
            'reason.max' => __('admin/validation/blocked-reason.reason.max'),
            'reason.unique' => __('admin/validation/blocked-reason.reason.unique'),
        ];
    }

    public function blocked_users()
    {

        return $this->hasMany('app\Model\Admin\BlockedUser', 'blocked_reason_id', 'id');
    }
}
