<?php
/**
 * Author: NMG
 * Description: Api mailer class to call email template
 * Dated: 05/September/2019
 */
namespace App\Mail\Api\V1;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendEmailTemplate extends Mailable
{
    use Queueable, SerializesModels;

    public $params;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($params)
    {
        $this->params = $params;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $fromEmail = (!empty($this->params['fromEmail']))?$this->params['fromEmail']:env('MAIL_FROM_ADDRESS');
        $fromName = (!empty($this->params['fromName']))?$this->params['fromName']:env('MAIL_FROM_NAME');
        
        if(!empty($this->params['attachment'])){
            return $this->view('emails.api.mail')
                        ->from($fromEmail, $fromName)
                        ->subject($this->params['subject'])
                        ->attach($this->params['attachment'], ['as' => $this->params['attachmentName']]); 
        }else{
            return $this->view('emails.api.mail')
                        ->from($fromEmail, $fromName)
                        ->subject($this->params['subject']);
        }
    }
}
