<?php

namespace app\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;

class Restaurant
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard('restaurant')->check()) {
            $role = \app\Model\Admin\Role::vendorHasRole($request);
            if ($role) {
                return $next($request);
            } else {
                abort('401');
                return redirect('access-denied');
            }
        }
        //echo Auth::guard('admin')->check() ? 'yyy' : 'uuuu';die;
        return $next($request);
    }
}