<?php

namespace App\Http\Middleware;

use app\Model\Admin\Facility;
use Auth;
use Closure;
use Illuminate\Support\Facades\App;

class FacilityAssignedCheking
{

    /**
     * @Method: handle()
     * @Scope: public
     * @params: @request
     * @Description: if facility user inactive or if not assigned any facility or if facility inactive the this middleware will work after refresh the page for only facility users.
     * @Created 15/Jan/2020
     * @Updated 15/Jan/2020
     */
    public function handle($request, Closure $next)
    {

        if (!empty(Auth::guard('admin')->user()) && Auth::guard('admin')->user()->role_id == config('admin.constants.SUB_ADMIN_ROLE')) {
            $facilityStatus = Facility::select('status')->where('role_id', config('admin.constants.SUB_ADMIN_ROLE'))->first();

            if (empty(Auth::guard('admin')->user()->facility_id)) {
                Auth::guard('admin')->logout();
                return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.facilityNotAssisned'));

            } else if ($facilityStatus->status == '0') {
                Auth::guard('admin')->logout();
                return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.userNotActivate'));

            } else if (Auth::guard('admin')->user()->status == '0') {
                Auth::guard('admin')->logout();
                return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.facilityUserNotActivate'));
            }

        }

        return $next($request);
    }

}
