<?php

namespace app\Http\Controllers\Web;

use Illuminate\Http\Request;
use app\Http\Controllers\Controller;
use app\Model\Admin\Role;
use app\Model\Admin\User;
use app\Model\Admin\UserAvatars;
use app\Model\Admin\StaticPage;
use DB;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Input;
use Validator;
use Session;

class TermsofservicesController extends Controller
{
  
     /**
     * @Method: index()
     * @Scope: public
     * @returns: redirect Terms of Service screen
     * @Description: display records on terms of services page.
     * @Created 13/July/2021
     * @Updated 13/July/2021
     */

    public function index()
    {
        try {
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'] = 'Terms of Service',
            ];
            $records = StaticPage::select('*')->where('id', 2)->first();

            $data['staticDetail'] = $records;
            $data = array_merge($data, $this->const, $this->breadCrumb);
            return view('Vendor/vendor/terms_of_services')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

     /**
     * @Method: privacyPolicy()
     * @Scope: public
     * @returns: redirect privacy policy screen
     * @Description: display records on privacy-policy page.
     * @Created 13/July/2021
     * @Updated 13/July/2021
     */

    public function privacyPolicy()
    {
        try {
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'] = 'Privacy Policy',
            ];
            $records = StaticPage::select('*')->where('id', 3)->first();

            $data['staticDetail'] = $records;
            $data = array_merge($data, $this->const, $this->breadCrumb);
            return view('Vendor/vendor/privacy_policy')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
}