<?php

namespace app\Http\Controllers\Web;

use app\Http\Controllers\Controller;
use app\Model\Admin\StaticPage;
use Illuminate\Http\Request;

class StaticPagesController extends Controller
{

    /**
     * @author: Akshay
     * @Method: termsOfUse()
     * @Scope: public
     * @Params: @null
     * @returns: display terms page
     * @Description: display the termsOfUse page
     * @Created 18/feb/2020
     * @Updated 18/feb/2020
     */

    public function termsOfUse()
    {
        try {
            $terms = StaticPage::where([['slug', '=', 'terms-of-use-for-application'], ['status', '=', '1']])->first();

            if (!empty($terms)) {
                $this->data['staticPage'] = $terms;
                $this->data['htmlTitle'] = !empty($terms->title) ? ucwords($terms->title) : '';
                $data = array_merge($this->data);
            }
            return \View('static-pages.page')->with($data);
        } catch (\Exception $e) {
            // $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @author: Akshay
     * @Method: termsOfUse()
     * @Scope: public
     * @Params: @null
     * @returns: display terms page
     * @Description: display the termsOfUse page
     * @Created 18/feb/2020
     * @Updated 18/feb/2020
     */


    public function privacyPolicy()
    {
        try {
            $privacyPolicy = StaticPage::where([['slug', '=', 'privacy-policy-for-application'], ['status', '=', '1']])->first();
            if (!empty($privacyPolicy)) {
                $this->data['staticPage'] = $privacyPolicy;
                $this->data['htmlTitle'] = !empty($privacyPolicy->title) ? ucwords($privacyPolicy->title) : '';
                $data = array_merge($this->data);
            }
            return \View('static-pages.page')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }


    /**
     * @author: Akshay
     * @Method: termsOfUse()
     * @Scope: public
     * @Params: @null
     * @returns: display terms page
     * @Description: display the termsOfUse page
     * @Created 18/feb/2020
     * @Updated 18/feb/2020
     */


    public function aboutUs()
    {
        try {
            $aboutUs = StaticPage::where([['slug', '=', 'about'], ['status', '=', '1']])->first();
            if (!empty($aboutUs)) {
                $this->data['staticPage'] = $aboutUs;
                $this->data['htmlTitle'] = !empty($aboutUs->title) ? ucwords($aboutUs->title) : '';
                $data = array_merge($this->data);
            }
            return \View('static-pages.page')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }



    public function restaurantPrivacyPolicy()
    {
        try {
            $content = StaticPage::where([['slug', '=', 'privacy-policy-for-restaurant'], ['status', '=', '1']])->first();
            if (!empty($content)) {
                $this->data['staticPage'] = $content;
                $this->data['htmlTitle'] = !empty($content->title) ? ucwords($content->title) : '';
                $data = array_merge($this->data);
            }
            return \View('static-pages.page')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    public function restaurantTermsOfUse()
    {
        try {
            $content = StaticPage::where([['slug', '=', 'terms-of-use-for-restaurant'], ['status', '=', '1']])->first();
            if (!empty($content)) {
                $this->data['staticPage'] = $content;
                $this->data['htmlTitle'] = !empty($content->title) ? ucwords($content->title) : '';
                $data = array_merge($this->data);
            }
            return \View('static-pages.page')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
}
