<?php
namespace app\Http\Controllers\Web;
 
use app\Http\Controllers\Controller;
use app\Model\Admin\Faq;


class FaqController extends Controller
{

    public function index(){
        try{
            $faqs = Faq::where([['status', '=', '1']])->get();
            if(!empty($faqs)){
                $this->data['title'] = 'Faq';
                $this->data['faqs'] = !empty($faqs) ? $faqs : [];
               
                $data = array_merge($this->data);
            }
            return \View('staticPages.faq')->with($data);
        }catch(\Exception $e){
           // $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
}