<?php

namespace app\Http\Controllers\Vendor;

use Illuminate\Http\Request;
use app\Http\Controllers\Vendor\BaseController;
use app\Model\Vendor\Notification;
use Validator;
use Auth;

class NotificationController extends BaseController
{
    //
    private $const;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;

    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variables like  @roleId, @roleName, @url within private scope of current class
     * @Created 31/aug/2021
     * @Updated 31/aug/2021
     */

    public function __construct(Notification $notification)
    {
        try {
            parent::__construct();
            $this->middleware('auth.restaurant')->except('vendorLogin');
            $this->url = config('admin.path.VENDOR_BASE_URL') . '/notification';
            $this->title = 'Notification';
            $this->controllerUri = 'notification';
            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;
            $this->notification = $notification;
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }


    /**
     * Author: Jaidev
     * Email: jaidev@nmgtechnologies.com
     * @Method: index()
     * @Scope: public
     * @Params: @page,
     * @returns: List of restaurant orders 
     * @Description: This function fetches  Restaurant orders from database, sets up
     *  breadcrumb & other constants. 
     * @Created 10/aug/2021
     * @Updated 10/aug/2021
     */
    public function index(Request $request)
    {
        try {
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'],
            ];
            $page = $request->query('page', 1);
            $this->subTitle = 'Order List';
            $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
            $this->const['page'] = $page;
            $this->const['formId'] = '';
            $this->const['limit'] = $limit;
            $this->const['subTitle'] = $this->subTitle;
            $request->request->add(['userId' => Auth::guard('restaurant')->user()->id]);
            $data['notificationList'] = $this->notification->list($request);
            $this->notification->where(['user_id' => Auth::guard('restaurant')->user()->id])->update(['is_read' => 1]);
            // dd($data['notificationList']);
            $data = array_merge($data, $this->const);
            return \View('Vendor.notification.index')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }






    /**
     * Author: Jaidev
     * Email: jaidev@nmgtechnologies.com
     * @Method: create()
     * @Scope: public
     * @input: menu items
     * @Description: Show input form
     * 
     */
    public function create()
    {
    }

    /**
     * Author: Jaidev
     * Email: jaidev@nmgtechnologies.com
     * @Method: store()
     * @Scope: public
     * @input: order data
     * @returns: After successful submition of data redirect to listing page 
     * @Description: Create the specified resource in storage.
     * @Created 10/aug/2021
     * @Updated 10/aug/2021
     */
    public function store(Request $request)
    {
    }



    /**
     * Author: Jaidev
     * Email: jaidev@nmgtechnologies.com
     * @Method: edit()
     * @Scope: public
     * @params: @id
     * @returns: Returns pre-populated form data with other constants used in UI
     * @Description: It only fetches restaurant menu detail as per given id & return change its status.
     * @Created 6/jul/2021
     * @Updated 6/jul/2021
     */
    public function edit($id)
    {
        // 
    }




    /**
     * Author: Jaidev
     * Email: jaidev@nmgtechnologies.com
     * @Method: show()
     * @Scope: public
     * @params: @id
     * @Description: show detail of records
     * @Created 10/aug/2021
     * @Updated 10/aug/2021
     */
    public function show($id)
    {
        //
    }
}
