<?php

namespace app\Http\Controllers\Vendor;

use app\Http\Controllers\Vendor\BaseController;
use Illuminate\Http\Request;
use app\Http\Controllers\Controller;
use Validator;
use Session;
use Auth;
use app\Model\Admin\ContactSupport;
use app\Model\Admin\ContactTitle;
use OpenApi\Annotations\Contact;
use app\Model\Admin\User;
use app\Model\Admin\Restaurant;
use app\Model\Admin\GlobalSetting;


class ContactUsController extends BaseController
{

    private $url;
    private $title;
    private $subTitle;
    private $breadCrumb;

    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variables like @avatarDir, @roleId, @roleName, @url within private scope of current class
     * @Created 14/July/2021
     * @Updated 14/July/2021
     */
    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.restaurant')->except('vendorLogin');

            $this->url = config('admin.path.VENDOR_BASE_URL') . '/contact-us';
            $this->subTitle = 'Contact Us';
            $formId = 'contactForm';

            $this->const['url'] = $this->url;
            $this->const['title'] = 'Contact Us';
            $this->const['subTitle'] = $this->subTitle;
            $this->const['formId'] = $formId;

            $this->controllerUri = 'contact-us';
            $this->const['controllerUri'] = $this->controllerUri;

            //default breadcrumb option (Dashboard) for every route
            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.VENDOR_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
            //dd($this->const);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: index()
     * @Scope: public
     * @returns: redirect Contact Us screen
     * @Description: display enquiry contact us page.
     * @Created 14/July/2021
     * @Updated 14/July/2021
     */

    public function index()
    {
        try {
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'],
            ];
            $data['titleList'] = ContactTitle::select('id', 'name')->where(['status' => 1])->orderBy('name', 'asc')->get()->pluck('name', 'id');
            $data = array_merge($data, $this->const, $this->breadCrumb);
            return view('Vendor/contact-us/index')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Author: Jaidev
     * Email: jaidev@nmgtechnologies.com
     * @Method: store()
     * @Scope: public
     * @input: contact form data
     * @returns: After successful submition of data redirect to same page with success msg 
     * @Description: Create the specified resource in storage.
     * @Created 14/jul/2021
     * @Updated 14/jul/2021
     */
    public function store(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                $input = $request->only(['title_id', 'message']);
                $validator = Validator::make($input, ContactSupport::Rules(), ContactSupport::messages());
                if ($validator->fails()) {
                    return \Redirect::back()->withInput()->withErrors($validator->errors());
                } else {
                    $user = Restaurant::where(['owner_id' => Auth::guard('restaurant')->user()->id])->first();
                    $input['user_id'] = Auth::guard('restaurant')->user()->id;
                    $status = ContactSupport::create($input);
                    if ($status) {
                        $titleData = ContactTitle::find($input['title_id']);
                        // dd($titleData);
                        $supportEmail = GlobalSetting::where(['slug' => 'support-mail'])->first();
                        ########  	Contact us email to admin only  ###########
                        if (!empty($input['lang'])) {
                            \App::setLocale($input['lang']);
                        }
                        $params['replaceKeywords']['{USER_NAME}'] = ucwords($user->name);
                        $params['replaceKeywords']['{TITLE}'] = $titleData->name;
                        $params['replaceKeywords']['{MESSAGE}'] = $input['message'];
                        $params['toEmail'] = $supportEmail->value;
                        $params['emailSlug'] = 'contact_email';
                        $this->customMailer($params);
                        ######## End Contact us email to admin only  ###########

                        \Session::flash('success', __('admin/flash_msg.success.contactUsCreated'));
                        return \Redirect::to($this->url);
                    } else {
                        return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.UnableToSaveContactForm'));
                    }
                }
            }
        } catch (\Exception $e) {
            dd($e->getMessage());
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
