<?php

/**
 * @Description: The `BaseController` have all the common methods or properties access throught
 *  the vendor panel as all vendor controller calss will extend it.
 * @auther: NMG - BS
 * @dated: 13/July/2021
 */

namespace app\Http\Controllers\Vendor;

use app\Http\Controllers\Controller;
use Auth;
use File;
use Illuminate\Http\Request;

class BaseController extends Controller
{
    /**
     * @Method: __construct()
     * @Scope: public
     * @Description: Verify vendor authentication & redirect request to corresponding controllers
     * @Created 13/July/2021
     * @Updated 13/July/2021
     */
    public function __construct()
    {
        $this->middleware('auth.restaurant');
        $this->middleware(function ($request, $next) {
            $this->user = Auth::guard('restaurant')->user();
            if (!$this->user) {
                return \Redirect::to(config("admin.constants.RESTAURANT_ROUTE_NAME"));
            } else if ($this->user->status == 0) {
                Auth::guard('restaurant')->logout();
                return \Redirect::to(config("admin.constants.RESTAURANT_ROUTE_NAME"))->with('success', __('admin/flash_msg.error.accountBlocked'));
            }
            return $next($request);
        });
    }
}
