<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;
use Illuminate\Http\Request;

class UpdatedAppController extends Controller
{
    /**
     *
     *
     *
     * @OA\Schema(
     *      schema="force_update_status",
     *           example={"code":200,"message":"Force Update Status.","data":{"androidVersion":"1.0.1","iosVersion":"1.0.2","forceUpdateAndroid":1,"forceUpdateIos":1,"androidMessage":"Android App Update Message","iosMessage":"IOS App Update Message"}}
     *       )
     *  )
     *
     *
     *
    *
    * @OA\Get(
    *     path="/api/force-update-status",
    *     operationId="force-update-status",
    *     tags={"Force Update"},
    *     summary="Force Update Status",
    *     description="Force Update Status.",
    *     @OA\Response(
    *         response="200",
    *         description="sucess.",
    *         @OA\JsonContent(ref="#/components/schemas/force_update_status"),
    *     ),
    *     @OA\Response(
    *         response="400",
    *         description="Error: Bad request.",
    *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
    *     ),
    *     @OA\Response(
    *         response="422",
    *         description="validation error",
    *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
    *     ),
    * )
    *
    * 
    *
    */
}
