<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;
use Illuminate\Http\Request;

class RestaurantController extends Controller
{
    /**
     *
     *
     *
     *
     *
     *
     *
     *
     *
     *   @OA\Schema(
     *      schema="restaurant_list_success",
     *      example={ "code": 200, "message": "Restaurant has been fetched", "data": {  "pageData": {"total": 3,"per_page": 10,"current_page": 1,"last_page": 1  },  "foodCategoryList": {{ "id": 11, "name": "Beverages", "image": "http://localhost/bmf/storage/app/public/uploads/food_category/11/610912ba3e712.png"},{ "id": 12, "name": "Burger", "image": "http://localhost/bmf/storage/app/public/uploads/food_category/12/610912af2e46e.png"},{ "id": 13, "name": "Desserts", "image": "http://localhost/bmf/storage/app/public/uploads/food_category/13/610912a39997c.png"},{ "id": 4, "name": "Non Veg", "image": "http://localhost/bmf/storage/app/public/uploads/food_category/4/610912daba9ce.png"},{ "id": 17, "name": "Pizza", "image": "http://localhost/bmf/storage/app/public/uploads/food_category/17/61091293bf8d2.png"},{ "id": 1, "name": "Veg", "image": "http://localhost/bmf/storage/app/public/uploads/food_category/1/610912e87a486.png"}  },  "restaurants": {{ "id": 29, "name": "Food Court", "restaurantType": "1,2", "deliveryTime": null, "distance": "0.66", "deliveryFee": 28.3, "restaurantImage": null, "categoryTypes": {}},{ "id": 5, "name": "Burger King", "restaurantType": "1", "deliveryTime": "15-20 min", "distance": "13.40", "deliveryFee": 92, "restaurantImage": "http://localhost/bmf/storage/app/public/uploads/avatar/29/60ffa6004adde.jpg", "categoryTypes": {  {"id": 11,"name": "Beverages"  },  {"id": 12,"name": "Burger"  } }},{ "id": 4, "name": "Parallax Restaurant", "restaurantType": "1,2,3", "deliveryTime": "", "distance": "18.75", "deliveryFee": 118.75, "restaurantImage": null, "categoryTypes": {}}  } }}
     *       )
     *  )
     *   @OA\Schema(
     *      schema="restaurant_details_success",
     *      example={"code": 200,"message": "Restaurant has been fetched","data": {"restaurant": {"id": 1,"name": "Jayka90","bio": "Diners Club International, founded as Diners Club, is a charge card company owned by Discover Financial Services.","categoryTypes": {{"id": 1,"name": "Veg"},{"id": 17,"name": "Pizza"}},"restaurantType": "1,2,3","deliveryTime": "15-20 minute","distance": 5,"deliveryFee": 50,"restaurantImage": "http://localhost/bmf/storage/app/public/uploads/avatar/4/60fe6ae3d154b.png"},"menuList": {{"foodCategory": "Veg","count": 1,"item": {"data": {{"id": 6,"restaurantId": "1","foodCategoryId": "1","name": "item name","image": "","price": "25.00","prepTime": "20","allergyAdvice": null,"description": "sdfasdf"}}}},{"foodCategory": "Pizza","count": 1,"item": {"data": {{"id": 9,"restaurantId": "1","foodCategoryId": "17","name": "Pizza 1","image": "","price": "22.00","prepTime": "66","allergyAdvice": "sf","description": "sdfsadf"}}}}}}}
     *       )
     *  )
     *
     *
     *
     *
     *
     *
     *  @OA\Get(
     *     path="/api/restaurant_list",
     *     operationId="restaurant_list",
     *     tags={"Restaurant"},
     *     summary="Get Restaurant List using user's latitude & longitude (withing allowed range).",
     *     description="Get Restaurant List using user's `latitude` & `longitude`.  `type` ref: [1=>`Local`,2=>`Continental`,3=>`Groceries`]",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="latitude",
     *                     type="string",
     *                 ),
     *
     *                  @OA\Property(
     *                     property="longitude",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="type",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="categoryId",
     *                     type="numeric",
     *                 ),
     *                  @OA\Property(
     *                     property="searchString",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="page",
     *                     type="numeric",
     *                 ),
     *
     *
     *                 example={"latitude": "32.1244","longitude": "123.34232","type": "1/2/3", "categoryId": "2","searchString": "string", "page": 1}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/restaurant_list_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * 
     *  @OA\Post(
     *     path="/api/restaurant_details",
     *     operationId="restaurant_details",
     *     tags={"Restaurant"},
     *     summary="Get Restaurant Details  ",
     *     description="Get Restaurant Details using `restaurant_id` , `latitude` & `longitude`",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="latitude",
     *                     type="string",
     *                 ),
     *
     *                  @OA\Property(
     *                     property="longitude",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="restaurantId",
     *                     type="string",
     *                 ),
     *                 example={"latitude": "28.4474839","longitude": "77.0900214","restaurantId": "1"}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/restaurant_details_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
 
     * 
     *
     *
     */
}
