<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    /**
     *
     *
     *   @OA\Schema(
     *      schema="order_list_success",
     *      example={ "code": 200, "message": "Order has been fetched", "data": {  "orderCount": 2,  "orders": {{ "orderId": 100002, "deliveryCharges": "398.00", "tax": "242.00", "totalAmount": "2910.00", "orderStatus": "Pending", "itemCount": 2, "itemList": {  {"itemName": "Dessert","itemCount": "2"  },  {"itemName": "Test Pizza","itemCount": "1"  } }},{ "orderId": 100001, "deliveryCharges": "50.00", "tax": "242.00", "totalAmount": "2910.00", "orderStatus": "Pending", "itemCount": 2, "itemList": {  {"itemName": "Dessert","itemCount": "2"  },  {"itemName": "Test Pizza","itemCount": "1"  } }}  },  "pageData": {"total": 2,"per_page": 10,"current_page": 1,"last_page": 1  } }}
     *       )
     *  )
     *
     *   *   @OA\Schema(
     *      schema="order_cancel_success",
     *      example={ "code": 200, "message": "Order has been canceled", "data": {}}
     *       )
     *  )
     *
     *  @OA\Schema(
     *      schema="order_detail_success",
     *      example={ "code": 200, "message": "Order has been fetched", "data": {  "orderId": 100001,  "deliveryCharges": "50.00",  "tax": "242.00",  "totalAmount": "2910.00",  "orderStatus": "Pending",  "orderStatusId": "1",  "deliveryCode": "2878",  "orderOn": 1628060103,  "itemCount": 2,  "itemList": {{ "itemName": "Dessert", "itemCount": "2", "itemPrice": "1200.00"},{ "itemName": "Test Pizza", "itemCount": "1", "itemPrice": "25.00"}  },  "restaurant": {"id": 3,"name": "Jaidev","deliveryTime": "15-30 Min","address": "Augusta Point, Golf Course Road, Parsvnath Exotica, DLF Phase 5, Sector 53, Gurugram, Haryana, India","phoneNumber": "8285392955"  } }}
     *       )
     *  )
     *
     *
     *
     *  @OA\Post(
     *     path="/api/order",
     *     operationId="order_list",
     *     tags={"Order"},
     *     summary="User's order list using `token`",
     *     description="User's order lising <br>Order Status options <br> `1`=> `Pending`,`2`=> `Accepted`,`3`=> `Rejected`,`4`=> `In Prep`,`5`=> `On the Way`,`6`=> `Completed`,`7`=> `Canceled`,`8`=> `Rejected by restaurant` , Important note : please send order status in array format like [1,6]",
     *  @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="orderStatus",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="page",
     *                     type="numeric",
     *                 ),
     *
     *
     *                 example={"orderStatus": null,"page": 1}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/order_list_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     * @OA\Get(
     *     path="/api/order/details",
     *     operationId="order_details",
     *     tags={"Order"},
     *     summary="Order details using `orderId`",
     *     description="Get order details using `orderId`",
     *     @OA\Parameter(
     *         name="orderId",
     *         in="path",
     *         description="Order id",
     *         required=true,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/order_detail_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *  @OA\Post(
     *     path="/api/order/cancel",
     *     operationId="order_cancel",
     *     tags={"Order"},
     *     summary="Cancel order using token & Order id",
     *     description="Cancel order using `orderId` & `token`",
     *  @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="orderId",
     *                     type="numeric",
     *                 ),
     *                 example={"orderId": 100010}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/order_cancel_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     *
     *

     *
     *
     *
     */
}
