<?php

namespace app\Http\Controllers\Documentation;

use Illuminate\Http\Request;

class MiscController extends BaseDocumentationController
{
    /**
     *
     *
     *  @OA\Schema(
     *      schema="contact_us_success",
     *      example={ "code": 200, "message": "Your Message has been successfully sent.", "data": {} }
     *       )
     *  )
     *
     *
     *
     *  @OA\Schema(
     *      schema="toggle-noti-success",
     *      example={ "code": 200, "message": "App Notification has been disabled", "data": {} }
     *       )
     *  )
     *
     *  @OA\Schema(
     *      schema="verify-password-success",
     *      example={ "code": 200, "message": "success", "data": { "status": true } }
     *       )
     *  )
     *
     *
     *
     *
     *
     *
     *
     * @OA\Post(
     *     path="/api/contact-us",
     *     operationId="contact-us",
     *     tags={"Misc"},
     *     summary="contact admin/restuarant_id for user",
     *     description="contact `admin/restuarant_id` for __user__ . `restaurant_id` is optional ",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="title",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="message",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="restaurant_id",
     *                     type="integer",
     *                 ),
     *
     *                 example={ "title":"save your mood", "message":"Invincible I will be ever", "restaurant_id": 5 }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/contact_us_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     * @OA\Put(
     *     path="/api/toggle-notification",
     *     operationId="toggle-notification",
     *     tags={"Misc"},
     *     summary="toggle notification enable/disable for current user",
     *     description="**toggle notification enable/disable** for current user",
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/toggle-noti-success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     * @OA\Post(
     *     path="/api/verify-password",
     *     operationId="verify-password",
     *     tags={"Misc"},
     *     summary="Check password for current user.",
     *     description="Check `password` for current user",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="password",
     *                     type="string",
     *                 ),
     *
     *                 example={"password": "P@ss1234"}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/verify-password-success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     *
     *

     *
     */
}
