<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CartController extends Controller
{
    /**
     *
     *
     *
     *
     *
     *
     *
     *
     *
     *   @OA\Schema(
     *      schema="add_to_cart_success",
     *      example={"code":200,"message":"Items has been added to cart ","data":{"summary":{"totalItems":"1","totalPrice":"40.00"}}}
     *       )
     *  )
     *   @OA\Schema(
     *      schema="cart_details_success",
     *      example={ "code": 200, "message": "Cart has been fetched", "data": {"cartId": 7,"restaurant": {"restaurantName": "Jaidev","restaurantAddress": "Augusta Point, Golf Course Road, Parsvnath Exotica, DLF Phase 5, Sector 53, Gurugram, Haryana, India","deliveryTime": "15-30 Min"},"item": {{ "itemName": "Dessert", "itemCount": "2", "itemCost": "1200.00"},{ "itemName": "Test Pizza", "itemCount": "1", "itemCost": "25.00"}},"price": {"orderCost": 2425,"serviceFee": 485,"deliveryFee": 50,"totalBill": 2960},"address": {"latitude": "28.14445","longitude": "78.256","addressLine": "new Other address, just anywhere1","addressType": "Other"} }}
     *       )
     *  )
     * 
     *  @OA\Schema(
     *      schema="update_address_success",
     *      example={"code":200,"message":"Address has been updated","data":{"cartId":3,"restaurant":{"restaurantId":27,"restaurantName":"Mick Reestaurant","restaurantAddress":"11 Beach Rd, Takoradi, Ghana","deliveryTime":"20-30"},"item":{{"itemName":"Magreeta Drink","itemCount":"4","itemCost":"10.00"}},"price":{"orderCost":40,"serviceFee":4,"deliveryFee":120,"totalBill":164},"address":{"latitude":"28.6609677","longitude":"77.2276704"}}}
     *       )
     *  )
     * 
     * @OA\Schema(
     *      schema="checkout_success",
     *      example={"code":200,"message":"Order has been placed ","data":{"restaurant_id":"27","user_id":"6","order_status_id":1,"firstname":"Sam","lastname":"Sharma","phone_number":"8888888889","email":"jaidev@nmgtechnologies.co","address1":"College","address2":"College","city":"Delhi","state":"Delhi","zipcode":"110019","address_type":"2","latitude":"28.6609677","longitude":"77.2276704","country":"Ghana","delivery_note":"Please deliver to neighbour if receiver not available","delivery_charge":120,"distance":"19.00","sub_total":40,"tax":2,"tax_percentage":"5","commission":4,"commission_percentage":"10","total_amount":166,"delivery_code":"9434","updated_at":"2021-08-26 06:50:59","created_at":"2021-08-26 06:50:59","id":100006,"transaction_id":14}}
     * )
     * 
     * 
     *
     *
     *
     *
     *  @OA\Post(
     *     path="/api/cart",
     *     operationId="cart",
     *     tags={"Cart"},
     *     summary="Add/update food items into cart using `addressId` , `itemId` and `itemQty`",
     *     description="User can add items into cart from single restaurant only.<br> Before processing add to cart, user need to select address from saved addressed.  <br>Params `addressId` , `itemId` and `itemQty`",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="addressId",
     *                     type="numeric",
     *                 ),
     *
     *                  @OA\Property(
     *                     property="itemId",
     *                     type="numeric",
     *                 ),
     *                  @OA\Property(
     *                     property="itemQty",
     *                     type="numeric",
     *                 ),
     *                 example={"latitude":"28.6609677","longitude":"77.2276704","itemId": 21,"itemQty": 4}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/add_to_cart_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * @OA\Post(
     *     path="/api/cart/address",
     *     operationId="cart_update_address",
     *     tags={"Cart"},
     *     summary="update delivery address using `addressId`",
     *     description="User can update delivery address",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="addressId",
     *                     type="numeric",
     *                 ),
     *
     *                 example={"latitude": "28.6609677","longitude": "77.2276704"}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/update_address_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     *  @OA\Get(
     *     path="/api/cart",
     *     operationId="cart_details",
     *     tags={"Cart"},
     *     summary="User's cart details using `token`",
     *     description="User's cart details",
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/cart_details_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * 
     *  @OA\Post(
     *     path="/api/cart/checkout",
     *     operationId="checkout",
     *     tags={"Cart"},
     *     summary="Checkout cart items using `paymentType` & `paymentStatus`",
     *     description="paymentType options `1`=>`CC`,`2`=>`COD` <br> paymentStatus options `0`=>`Failure`,`1`=>`success`	",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="txtNo",
     *                     type="string",
     *                 ),
     *                   @OA\Property(
     *                     property="paymentType",
     *                     type="string",
     *                 ),
     *                   @OA\Property(
     *                     property="paymentStatus",
     *                     type="string",
     *                 ),
     *
     *                 example={"paymentType":"1","paymentStatus":"1","txnNo":"txn-007","addressId":33,"deliveryNote":"Please deliver to neighbour if receiver not available"}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/checkout_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * 
     * 
     * 
     * 
     * 
     * 
     * 
 
     * 
     *
     *
     */
}
