<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;
use Illuminate\Http\Request;

class BaseDocumentationController extends Controller
{

    /**
     * @OA\Server(
     *      url="https://demo.newmediaguru.co/bmf-dev",
     *   )
     *
     * @OA\Server(
     *      url="http://localhost/bmf",
     *  )
     *
     *
     *
     * @OA\Info(
     *   title="BMF API Documentation",
     *   version="1.0",
     *   description="BMF APP",
     *   @OA\Contact(
     *     email="bibhash.shisodiya@nmgtechnologies.com",
     *     name="PHP Team"
     *   ),
     * ),
     *
     *
     *
     * @OA\SecurityScheme(
     *     @OA\Flow(
     *         flow="clientCredentials",
     *         tokenUrl="oauth/token",
     *         scopes={}
     *     ),
     *     securityScheme="bearerAuth",
     *     in="header",
     *     type="http",
     *     description="Oauth2 security",
     *     name="Authorization",
     *     scheme="bearer",
     *     bearerFormat="JWT",
     * )
     *
     * @OA\Header(
     *      header="accept", @OA\Schema
     * )
     *
     * @OA\Schema(
     *      schema="authentication_error",
     *      example={ "code": 401, "error": "Please provide AccessToken in header", "data": {} }
     *  )
     *
     *
     * @OA\Schema(
     *      schema="validation_error",
     *           example={ "code": 422, "message": "Please provide AccessToken in header", "data": {} }
     *       )
     *  )
     *
     *
     *
     * @OA\Schema(
     *      schema="bad_request",
     *           example={ "code": 400, "message": "xxx yyyy zzzz.", "data": {} }
     *       )
     *  )
     *
     * @OA\Schema(
     *      schema="invalid_json",
     *           example={ "code": 415, "message": "Invalid JSON", "data": {} }
     *       )
     *  )
     *
     *
     */
}
