<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    /**
     *
     *
     *
     *
     * @OA\Schema(
     *      schema="user_registration_success",
     *           example={
     *                      "code": 200,
     *                      "message": "You have been successfully signed up",
     *                      "data": {
     *                                  "profile": {
     *                                       "userId": 22,
     *                                       "fullName": "nmg tech",
     *                                       "email": "nmg@mail.com",
     *                                       "phone": "9876543210",
     *                                       "isDeliveryPerson": false,
     *                                       "userImage": null
     *                                   },
     *                                   "token": {
     *                                       "token_type": "Bearer",
     *                                       "expires_in": 15897600,
     *                                       "access_token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImp0aSI6ImM4MDVmZWViZDdmZTVjMTNjOWI1NzM3OTNlYTg0MTYwNTkwYjQ3YTJhODExOTliNjJlZjBkMTc5Mzk5OGFhZTg2NmY0YzI0YmI5ZTZlNzM5In0.eyJhdWQiOiIyIiwianRpIjoiYzgwNWZlZWJkN2ZlNWMxM2M5YjU3Mzc5M2VhODQxNjA1OTBiNDdhMmE4MTE5OWI2MmVmMGQxNzkzOTk4YWFlODY2ZjRjMjRiYjllNmU3MzkiLCJpYXQiOjE2MjY2ODgwMzAsIm5iZiI6MTYyNjY4ODAzMCwiZXhwIjoxNjQyNTg1NjMwLCJzdWIiOiIyMiIsInNjb3BlcyI6W119.s46zMoIk3L0goeYdhUKUbB7fcw37fe9hqr3m7HDwHADPmq1clYeIketaElg3qRba_DMaFs9fD9HZkUJ79cA_AGXpsafXABMYbzgJcRsyNDY-mARh8GdEjH_pp98BZRllICHTaoECdlbnVOdZZHZVeSHk-R9ihjNOt5-q98UxfDUPNbARz_kEDonVlmk-fr5wsZz3KaZXAo_aYxHhZc443q_s4t1Tn8B9AFvckDTWKbCU_CxnqDRnWxc9oCgKl_M73yYR3W9Szs2GB6wuViLvEfxfp4QnMRrGXEttsy0lqv1suPcWaMJGYybkT___OTUg46QcvEx0QasYf8ukHMABneU3WVgm244fD30QJv8IRcpwTsFVuSLcYKO1ECU16mEgcp3F0GwmP44HNN5bd76drCxC1rAZw4684jajsYNKpn6RQAWGCGwc5JTsYDLWemzFLfjReRrhjERfNRd50dpiN9IoxkEOKNIYuy4wvQIVjPdYtQ-oY9Y5yL9ie1oSR284flhg6mfCUBaBECjLcGkfUvRPOg_6xeUXUPK2BPm1f_DV2iEos8FCw70jgzUqMeRIpILoPVw2LVYWFIxUJaIECTFeedZI0_fwO_B6kaJmHMd_4rOITSHiynAIaEpwOoYwEt5g83Vyg__nWs4nN3JuncSOZMmXPJjT4GorDh2iHh8",
     *                                       "refresh_token": "def502005fd59b102e36859573b910f8cd2ebf0a7a983397d6ebdbe181814cfce35636bbc7631aa08efff28ba9ee07ffdf28adccd9a121ca4e52ab54170b170c9203544fed75c294c5d39fb5a3eed61b832e862bd09ca09aa1d9e63d79ea5881e2ff071de0ba28d671697a43522be5000d76bb3a052f66f58e7374da21d8b43a714abc88c3ad63c18552889fcd5a5dac7895ecb63861cee76e4a9fa4377b5f4cfcbc10881d6f74abda7abf3737941d1574716f12955cb180831ab89d7eef491ee7b7af76e32710bfbf32d7a227acb919d1e35759b3866343694096eb25b54fa557e111482abcb83edb62c83eab4b7c5ce231145e838d946f41c829c37d6895947bafeda0b186b712ca254867bcbfe610aadfd81b581faab18860337de1448cb64fd4f89f80ab22008a123883eb96f1eff7e1f079706e3bcb4b08bc2b32d88423b51dd847f5c30d202922f8996840b2dc0c15d59759aa8361e33189cee381d5534bb5"
     *                                   }
     *
     *                                 }
     *                          }
     *       )
     *  )
     *
     *
     * @OA\Schema(
     *      schema="read_notification_success",
     *      example={"code":200,"message":"Notification marked read successfully","data":{}}
     *       )
     *  )
     *
     *
     * @OA\Schema(
     *      schema="account_deactivate_success",
     *      example={
    "code": 200,
    "message": "Profile has been deactivated successfully",
    "data": {}
}
     *       )
     *  )
     *
     *  @OA\Schema(
     *      schema="login_success",
     *      example={"code":200,"message":"You have been successfully logged in.","data":{"profile":{"userId":2,"fullName":"Bibhash Shishodiya","email":"test@nmgtechnologies.com","phone":"8888888888","isDeliveryPerson":false,"userImage":null},"token":{"token_type":"Bearer","expires_in":15897599,"access_token":"eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImp0aSI6Ijk0YTFjMGExYzVlZmRhMWJmMDBjOTYyZDNkY2ZmZDFjOGRiYjRhMzQ0MDAzNDlmNTE5OTgyYWZhM2VkYjc2MDMxZTYxNTMwMzZkY2YzNmY5In0.eyJhdWQiOiIyIiwianRpIjoiOTRhMWMwYTFjNWVmZGExYmYwMGM5NjJkM2RjZmZkMWM4ZGJiNGEzNDQwMDM0OWY1MTk5ODJhZmEzZWRiNzYwMzFlNjE1MzAzNmRjZjM2ZjkiLCJpYXQiOjE2MjY1Mjg2MjYsIm5iZiI6MTYyNjUyODYyNiwiZXhwIjoxNjQyNDI2MjI1LCJzdWIiOiIyIiwic2NvcGVzIjpbXX0.g8blayRFsXQgp2s-dsa39rFAijgb5zvN-DMKllWwXGct08K7nC0kCbw766EbOR3Kgw9hbbRWlmmgIl4saO1xsBx7NtwnbwCTFrU0VdK8fAb2g83WP3G792ArujCveP_uONpAvgq3gfbbdxp6XHi5UIoKZZKxg9NCSNG-VdUk3o-Z73alYVMldsGOn35HepKipI8jymju89RSmDD0qUyiokaXlzCeI5Jekg2JGtcT_NTEZyG5xYo6psBUHOMwjvrGkfVjwlBAbb_W2VFgTXdrFZ4ePRrJLAvaOnDfbdsM6FDBx77eVzB5tfhjQCftTfKpYYlfrYO4he189KCweFC2Kt3Cth651zumyQcpsHDe-0uqQ0l-gNRHla45Raz6C9AzjqxcXhPdq0XQiQAYEOJ6fuYXdHRP0iCb3hPhxZun3jMuMY0XihGU-2vqA-vSdD71bhOHSFmwVPMnrqukAjnQ6kc04ZttML-UaL1pfHI8SDGFPBggDk95BUx-tNTJ63U3KvjOuOPTIkW1Q66gzRtt1jF9okIRRFVa8EPjI506IVF98t8A45pMZ8DpPDFNex6dIVO-109-sYcG4hKG-UI3B5H9wfbtZHWmuISSjwuHLWp2JVWcmbmr68P4u-Efu9dloklFy4tlrQYYxHxaqE3759O0YYItJNoKytmDzqHBpDg","refresh_token":"def5020067881940e1ed22261a5f512dadbeb0edf4a1bd0fdbe5c4b585b38dde377b2f6d0e263631058db96c41cd9a42a39661f0bf6fa2b24344f3a0b8722680f70fbb3427202843874e7675c547da2a7a381fbd5a1e943676ca78ea3022752f16d1449157c38ddcafc9aa23befeeb9e2929529978124488f711ea50a50eed39ac3c2dc9eb490343f4a9a870c2dcf15af3d5e0ae9093b32a8e0e0ede4b179bae33c80e7809e78665050480c6a453fef4b7d19880b308fa55b7363ab5c0d369060c037f0ac0b4af0bdf46a8fd1541a5069388eb9ca63712389d2381de617c18c59f8083e0b362b73065040b32741cd87511ffd02bae552e81e6dfd75184ea9c5015eba77b74509709f959e09b9c4d8639bfb2930283126dace538fc94d32e618912a03c17d1db7ec0fb9a6d297a9f7c45b53ddfac207eb087a6b0a2659c1e038ba90951262fc46970412a8bc436de3c2e792ceb1ca4621d9d3c024ac33f93b5be93"}}}
     *       )
     *  )
     *
     *
     *     @OA\Schema(
     *      schema="account_verify_success",
     *      example={{"code":200,"message":"Thanks! Your mobile number is verified.","data":{"profile":{"userId":2,"fullName":"Bibhash Shishodiya","email":"test@nmgtechnologies.com","phone":"8888888888","isDeliveryPerson":false,"userImage":null},"token":{"token_type":"Bearer","expires_in":15897599,"access_token":"eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImp0aSI6Ijk0YTFjMGExYzVlZmRhMWJmMDBjOTYyZDNkY2ZmZDFjOGRiYjRhMzQ0MDAzNDlmNTE5OTgyYWZhM2VkYjc2MDMxZTYxNTMwMzZkY2YzNmY5In0.eyJhdWQiOiIyIiwianRpIjoiOTRhMWMwYTFjNWVmZGExYmYwMGM5NjJkM2RjZmZkMWM4ZGJiNGEzNDQwMDM0OWY1MTk5ODJhZmEzZWRiNzYwMzFlNjE1MzAzNmRjZjM2ZjkiLCJpYXQiOjE2MjY1Mjg2MjYsIm5iZiI6MTYyNjUyODYyNiwiZXhwIjoxNjQyNDI2MjI1LCJzdWIiOiIyIiwic2NvcGVzIjpbXX0.g8blayRFsXQgp2s-dsa39rFAijgb5zvN-DMKllWwXGct08K7nC0kCbw766EbOR3Kgw9hbbRWlmmgIl4saO1xsBx7NtwnbwCTFrU0VdK8fAb2g83WP3G792ArujCveP_uONpAvgq3gfbbdxp6XHi5UIoKZZKxg9NCSNG-VdUk3o-Z73alYVMldsGOn35HepKipI8jymju89RSmDD0qUyiokaXlzCeI5Jekg2JGtcT_NTEZyG5xYo6psBUHOMwjvrGkfVjwlBAbb_W2VFgTXdrFZ4ePRrJLAvaOnDfbdsM6FDBx77eVzB5tfhjQCftTfKpYYlfrYO4he189KCweFC2Kt3Cth651zumyQcpsHDe-0uqQ0l-gNRHla45Raz6C9AzjqxcXhPdq0XQiQAYEOJ6fuYXdHRP0iCb3hPhxZun3jMuMY0XihGU-2vqA-vSdD71bhOHSFmwVPMnrqukAjnQ6kc04ZttML-UaL1pfHI8SDGFPBggDk95BUx-tNTJ63U3KvjOuOPTIkW1Q66gzRtt1jF9okIRRFVa8EPjI506IVF98t8A45pMZ8DpPDFNex6dIVO-109-sYcG4hKG-UI3B5H9wfbtZHWmuISSjwuHLWp2JVWcmbmr68P4u-Efu9dloklFy4tlrQYYxHxaqE3759O0YYItJNoKytmDzqHBpDg","refresh_token":"def5020067881940e1ed22261a5f512dadbeb0edf4a1bd0fdbe5c4b585b38dde377b2f6d0e263631058db96c41cd9a42a39661f0bf6fa2b24344f3a0b8722680f70fbb3427202843874e7675c547da2a7a381fbd5a1e943676ca78ea3022752f16d1449157c38ddcafc9aa23befeeb9e2929529978124488f711ea50a50eed39ac3c2dc9eb490343f4a9a870c2dcf15af3d5e0ae9093b32a8e0e0ede4b179bae33c80e7809e78665050480c6a453fef4b7d19880b308fa55b7363ab5c0d369060c037f0ac0b4af0bdf46a8fd1541a5069388eb9ca63712389d2381de617c18c59f8083e0b362b73065040b32741cd87511ffd02bae552e81e6dfd75184ea9c5015eba77b74509709f959e09b9c4d8639bfb2930283126dace538fc94d32e618912a03c17d1db7ec0fb9a6d297a9f7c45b53ddfac207eb087a6b0a2659c1e038ba90951262fc46970412a8bc436de3c2e792ceb1ca4621d9d3c024ac33f93b5be93"}}}}
     *       )
     *  )
     *      @OA\Schema(
     *      schema="email_verify_success",
     *      example={ "code": 200, "status": "success", "message": "your email is verified successfully" }
     *       )
     *  )
     *
     *    @OA\Schema(
     *      schema="forgot_password_success",
     *      example={ "code": 200, "status": "success", "message": "Verification code sent successfully.", "data": {} }
     *       )
     *  )
     *
     *    @OA\Schema(
     *      schema="verify_email_success",
     *      example={ "code": 200, "message": "Your email has been updated successfully", "data": {} }
     *       )
     *  )
     *
     *    @OA\Schema(
     *      schema="change_password_success",
     *      example={ "code": 200, "status": "success", "message": "Your password has been changed successfully.", "data": {} }
     *       )
     *  )
     *
     *    @OA\Schema(
     *      schema="staticpages_success",
     *      example={ "code": 200, "message": "URL fetch successfully.", "data": {  "url": "https://demo.newmediaguru.co/bmf-dev/about" }}
     *       )
     *  )
     *
     *      @OA\Schema(
     *      schema="change_mobile_success",
     *      example={ "code": 200, "status": "success", "message": "Verification code sent successfully.", "data": {} }
     *       )
     *  )
     *
     *
     *      @OA\Schema(
     *      schema="update_mobile_success",
     *      example={ "code": 200, "status": "success", "message": "Your Mobile no. has been updated successfully.", "data": {} }
     *       )
     *  )
     *
     *      @OA\Schema(
     *      schema="chamge_email_success",
     *      example={ "code": 200, "message": "Otp sent successfully, please check your mail / phone Inbox", "data": {} }
     *       )
     *  )
     *
     *
     *
     *
     *     @OA\Schema(
     *      schema="profile_success",
     *      example={ "code": 200,  "message": "Your profile has been successfully fetched.",
     *          "data": {
     *              "profile": {
     *              "userId": 36,
     *              "userName": "dipak",
     *              "fullName": "dipak  verma",
     *              "email": "dipakverma@yopmail.com",
     *              "mobile_no": "1234512345",
     *              "userImage": null
     *               }
     *              } }
     *       )
     *  )
     *
     *     @OA\Schema(
     *      schema="upd_profile_success",
     *      example={ "code": 200,  "message": "Your profile has been successfully updated..",
     *          "data": {
     *              "profile": {
     *              "userId": 36,
     *              "userName": "dipak",
     *              "fullName": "dipak  verma",
     *              "email": "dipakverma@yopmail.com",
     *              "mobile_no": "1234512345",
     *              "userImage": null
     *               }
     *              } }
     *       )
     *  )
     *
     * @OA\Schema(
     *      schema="logout_success",
     *      example={ "code": 200, "status": "success", "message": "Logout successfully.", "data": {} }
     *       )
     *  )
     *
     * @OA\Post(
     *     path="/api/register",
     *     operationId="register",
     *     tags={"Pre Login"},
     *     summary="register customer",
     *     description="register customer  in system",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *
     *                  @OA\Property(
     *                     property="firstName",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="lastName",
     *                     type="string"
     *                 ),
     *
     *                  @OA\Property(
     *                     property="phone",
     *                     type="string"
     *                 ),
     *                  @OA\Property(
     *                     property="email",
     *                     type="string"
     *                 ),
     *                  @OA\Property(
     *                     property="password",
     *                     type="string"
     *                 ),
     *                  @OA\Property(
     *                     property="deviceToken",
     *                     type="string"
     *                 ),
     *                  @OA\Property(
     *                     property="deviceType",
     *                     type="string"
     *                 ),
     *
     *                 example={
     *                              "firstName": "Nmg",
     *                              "lastName": "Tech",
     *                              "phone": "9876543210",
     *                              "email": "nmgtech@gmail.com",
     *                              "password":"Nmg@1234",
     *                              "deviceToken": "adsqwrj;lqrl;q[2p1kprk32[rmqdasdwda2123",
     *                              "deviceType": "1/2",
     *                      }
     *             )
     *         )
     *     ),

     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/user_registration_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * )
     *
     *

     *
     *
     * @OA\Post(
     *     path="/api/login",
     *     operationId="login",
     *     tags={"Pre Login"},
     *     summary="login user by phone no and password.",
     *     description="login using {`phone no`} and `password`.",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="phone",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="password",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     property="deviceToken",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     property="deviceType",
     *                     type="string",
     *                 ),
     *
     *                 example={ "phone": "8888888888", "password": "Admin@1234", "deviceToken": "ANDROID12345", "deviceType": "ios/android"}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/login_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * )
     *
     * @OA\Post(
     *     path="/api/verifyAccount",
     *     operationId="verifyAccount",
     *     tags={"Pre Login"},
     *     summary="verify otp.",
     *     description="Type : 1 (SignUp) , 2 (Reset Password), 3 (Change Phone)",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="phone",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="otp",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     property="type",
     *                     type="string",
     *                 ),
     *                 example={ "phone": "88888888", "otp": "1996", "type": "1/2/3"}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/account_verify_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * )
     *
     * @OA\Post(
     *     path="/api/verify_email",
     *     operationId="verify_email",
     *     tags={"Pre Login"},
     *     summary="verify email .",
     *     description="verify email using otp",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="email",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="otp",
     *                     type="string",
     *                 ),
     *                 example={ "email": "dipakverma3896@yopmail.com", "otp": "1996" }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/email_verify_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * )
     *
     * @OA\Post(
     *     path="/api/change_password",
     *     operationId="changepassword",
     *     tags={"Post Login"},
     *     summary="Change Password Using Old Password.",
     *     description="change password using old `password`.",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="password",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="newPassword",
     *                     type="string",
     *                 ),
     *                 example={ "password": "123456", "newPassword": "123123"}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/change_password_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     * @OA\Get(
     *     path="/api/profile",
     *     operationId="profile",
     *     tags={"Post Login"},
     *     summary="User Profile.",
     *     description="user profile`.",
     *
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/profile_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     * @OA\Post(
     *     path="/api/update_profile",
     *     operationId="update_profile",
     *     tags={"Post Login"},
     *     summary="Update User Profile.",
     *     description="**Update user profile**.",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="fullName",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="userImage",
     *                     type="string",
     *                 ),
     *                 example={"fullName": "Wild Flower", "userImage": "http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/images/BigBuckBunny.jpg"}
     *             )
     *         )
     *     ),
     *
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/upd_profile_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     * @OA\Post(
     *     path="/api/logout",
     *     operationId="logout",
     *     tags={"Post Login"},
     *     summary="Logout User.",
     *     description="logout user.",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *
     *                 example={  }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/logout_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     * @OA\Post(
     *     path="/api/forgot_password",
     *     operationId="forgot_password",
     *     tags={"Pre Login"},
     *     summary="forgot password by phone",
     *     description="forgot password `phone`.",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="phone",
     *                     type="string",
     *                 ),
     *                 example={ "phone": "8285392945"}
     *             )
     *         )
     *     ),

     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/forgot_password_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * )
     *
     *  @OA\Post(
     *     path="/api/reset_password",
     *     operationId="reset_password",
     *     tags={"Pre Login"},
     *     summary="reset password by phone",
     *     description="reset password `phone`.",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="phone",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="otp",
     *                     type="numeric",
     *                 ),
     *                  @OA\Property(
     *                     property="password",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="password_confirmation",
     *                     type="string",
     *                 ),
     *                 example={ "phone": "8285392945","otp":"1234","password":"Abc@12345","password_confirmation":"Abc@12345"}
     *             )
     *         )
     *     ),

     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/change_password_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * )
     *
     *
     *    @OA\Get(
     *     path="/api/staticpages/about",
     *     operationId="staticpages",
     *     tags={"Pre Login"},
     *     summary="get cms page using slug name like about",
     *     description="cms page `slug`. like /api/staticpages/{slug} , slugs['About'=>'about','Terms of Service For Restaurant'=>'terms-of-use-for-restaurant','Privacy Policy For Restaurant'=>'privacy-policy-for-restaurant','Terms of Service For Application'=>'terms-of-use-for-application','Privacy Policy For Application'=>'privacy-policy-for-application']",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *
     *         )
     *     ),

     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/staticpages_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     * )
     *
     *
     * @OA\Post(
     *     path="/api/change_mobile",
     *     operationId="change_mobile",
     *     tags={"Post Login"},
     *     summary="Send Otp  to Old Mobile .",
     *     description="send otp to old `mobile` .",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="mobile_no",
     *                     type="string",
     *                 ),
     *
     *                 example={ "mobile_no": "8423593896" }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/change_mobile_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     * @OA\Put(
     *     path="/api/profile/deactivate",
     *     operationId="deactivate_account",
     *     tags={"Post Login"},
     *     summary="Deactivate user account .",
     *     description="User can deactivate his/her account using this api",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                 example={}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/account_deactivate_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *

     *
     *  @OA\Post(
     *     path="/api/update_mobile",
     *     operationId="update_mobile",
     *     tags={"Post Login"},
     *     summary="Update Mobile Using Old Mobile Otp.",
     *     description="update mobile when verify old mobile otp.",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="mobile_no",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="otp",
     *                     type="numeric",
     *                 ),
     *
     *
     *                 example={ "mobile_no": "8423593896","otp":"1122" }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/update_mobile_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     * @OA\Post(
     *     path="/api/change-email",
     *     operationId="change-email",
     *     tags={"Post Login"},
     *     summary="Check password for current user.",
     *     description="Check `password` for current user",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="email",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="confirm_email",
     *                     type="string",
     *                 ),
     *                 example={ "email": "sumit11@yopmail.com", "confirm_email": "sumit11@yopmail.com" }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/chamge_email_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     * @OA\Post(
     *     path="/api/validate-email",
     *     operationId="validate-email",
     *     tags={"Post Login"},
     *     summary="validate tmp email and convert to email.",
     *     description="validate tmp email and convert to email",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="email",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="otp",
     *                     type="string",
     *                 ),
     *                 example={ "email": "sumit11@yopmail.com", "otp": "8833"}
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/verify_email_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     * @OA\Get(
     *     path="/api/notifications",
     *     operationId="notifications",
     *     tags={"Notification"},
     *     summary="Get user's notification",
     *     description="Get user's `notification`",
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *  @OA\Put(
     *     path="/api/notifications/read",
     *     operationId="read_mark_notifications",
     *     tags={"Notification"},
     *     summary="Mark read notification",
     *     description="Mark read `notification`",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="id",
     *                     type="numeric",
     *                 ),
     *                 example={"id": 35}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/read_notification_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     *
     *
     */
}
