<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;

class ApiRiderController extends Controller
{
    /**
     *
     *
     *
     *
     *  @OA\Schema(
     *      schema="update_current_location",
     *      example={"code": 200,"message": "Location has been updated ","data": {}}
     *       )
     *  )
     * 
     * @OA\Schema(
     *      schema="rider_earning_success",
     *      example={"code":200,"message":"Earnings fetch successfully","data":{"weeklyOrders":"1","weeklyEernings":"60.00","todayOrders":"1","todayEarnings":"60.00"}}
     *       )
     *  )
     * 
     * 
     * @OA\Schema(
     *      schema="rider_order_complete_success",
     *      example={"code":200,"message":"Order has been completed","data":{}}
     *       )
     *  )
     * 
     * @OA\Schema(
     *      schema="rider_order_accept_success",
     *      example={"code": 200,"message": "Order has been accepted","data": {}}
     *       )
     *  )
     * 
     * @OA\Schema(
     *      schema="rider_order_reject_success",
     *      example={"code": 200,"message": "Order has been rejected","data": {}}
     *       )
     *  )
     * 
     *   @OA\Schema(
     *      schema="apply_rider_success",
     *      example={ "code": 200, "message": "success", "data": { "rider": { "id": 1, "user_id": "2", "full_name": "Sumit Sharma", "email": "sumit21@yopmail.com", "profile_image": null, "is_delivery_person": "0", "phone_number": "9667471608", "age": "25", "id_proof": "http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/images/BigBuckBunny.jpg", "vehicle_info": "http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/images/ElephantsDream.jpg", "driving_license": null, "bank": "Ecobank", "account_details": null, "work_status": "offline", "status": "Pending" } } }
     *       )
     *  )
     * 
     *  @OA\Schema(
     *      schema="rider_order_success",
     *      example={ "code": 200, "message": "Order has been fetched", "data": {  "orderCount": 7,  "orders": {{ "orderId": 100010, "deliveryCharges": "92.00", "tax": "19.00", "totalAmount": "330.00", "orderStatus": "In Prep", "orderStatusId": "4", "deliveryCode": "6810", "orderOn": 1628248308, "itemCount": 2, "itemList": {  {"itemName": "cocktail","itemCount": "4","itemPrice": "25.00"  },  {"itemName": "Test Item Name","itemCount": "3","itemPrice": "33.00"  } }, "address": "NMG Tech , Third Floor , Augusta Point , Gurugram", "latitude": "28.4474839", "longitude": "77.0900214", "orderAcceptStatus": "1", "riderEarningAmount": "92.00", "restaurant": {  "id": 5,  "name": "Burger King",  "deliveryTime": "15-20 min",  "address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India",  "phoneNumber": "8285392945",  "latitude": "28.562006",  "longitude": "77.2681095" }},{ "orderId": 100009, "deliveryCharges": "92.00", "tax": "19.00", "totalAmount": "330.00", "orderStatus": "In Prep", "orderStatusId": "4", "deliveryCode": "3494", "orderOn": 1628248275, "itemCount": 2, "itemList": {  {"itemName": "cocktail","itemCount": "4","itemPrice": "25.00"  },  {"itemName": "Test Item Name","itemCount": "3","itemPrice": "33.00"  } }, "address": "NMG Tech , Third Floor , Augusta Point , Gurugram", "latitude": "28.4474839", "longitude": "77.0900214", "orderAcceptStatus": "1", "riderEarningAmount": "92.00", "restaurant": {  "id": 5,  "name": "Burger King",  "deliveryTime": "15-20 min",  "address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India",  "phoneNumber": "8285392945",  "latitude": "28.562006",  "longitude": "77.2681095" }},{ "orderId": 100003, "deliveryCharges": "92.00", "tax": "19.00", "totalAmount": "330.00", "orderStatus": "In Prep", "orderStatusId": "4", "deliveryCode": "3681", "orderOn": 1628246725, "itemCount": 2, "itemList": {  {"itemName": "cocktail","itemCount": "4","itemPrice": "25.00"  },  {"itemName": "Test Item Name","itemCount": "3","itemPrice": "33.00"  } }, "address": "NMG Tech , Third Floor , Augusta Point , Gurugram", "latitude": "28.4474839", "longitude": "77.0900214", "orderAcceptStatus": "1", "riderEarningAmount": "92.00", "restaurant": {  "id": 5,  "name": "Burger King",  "deliveryTime": "15-20 min",  "address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India",  "phoneNumber": "8285392945",  "latitude": "28.562006",  "longitude": "77.2681095" }},{ "orderId": 100007, "deliveryCharges": "92.00", "tax": "19.00", "totalAmount": "330.00", "orderStatus": "In Prep", "orderStatusId": "4", "deliveryCode": "6707", "orderOn": 1628248174, "itemCount": 2, "itemList": {  {"itemName": "cocktail","itemCount": "4","itemPrice": "25.00"  },  {"itemName": "Test Item Name","itemCount": "3","itemPrice": "33.00"  } }, "address": "NMG Tech , Third Floor , Augusta Point , Gurugram", "latitude": "28.4474839", "longitude": "77.0900214", "orderAcceptStatus": "1", "riderEarningAmount": "92.00", "restaurant": {  "id": 5,  "name": "Burger King",  "deliveryTime": "15-20 min",  "address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India",  "phoneNumber": "8285392945",  "latitude": "28.562006",  "longitude": "77.2681095" }},{ "orderId": 100008, "deliveryCharges": "92.00", "tax": "19.00", "totalAmount": "330.00", "orderStatus": "In Prep", "orderStatusId": "4", "deliveryCode": "9583", "orderOn": 1628248238, "itemCount": 2, "itemList": {  {"itemName": "cocktail","itemCount": "4","itemPrice": "25.00"  },  {"itemName": "Test Item Name","itemCount": "3","itemPrice": "33.00"  } }, "address": "NMG Tech , Third Floor , Augusta Point , Gurugram", "latitude": "28.4474839", "longitude": "77.0900214", "orderAcceptStatus": "1", "riderEarningAmount": "92.00", "restaurant": {  "id": 5,  "name": "Burger King",  "deliveryTime": "15-20 min",  "address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India",  "phoneNumber": "8285392945",  "latitude": "28.562006",  "longitude": "77.2681095" }},{ "orderId": 100006, "deliveryCharges": "92.00", "tax": "19.00", "totalAmount": "330.00", "orderStatus": "In Prep", "orderStatusId": "4", "deliveryCode": "8508", "orderOn": 1628248130, "itemCount": 2, "itemList": {  {"itemName": "cocktail","itemCount": "4","itemPrice": "25.00"  },  {"itemName": "Test Item Name","itemCount": "3","itemPrice": "33.00"  } }, "address": "NMG Tech , Third Floor , Augusta Point , Gurugram", "latitude": "28.4474839", "longitude": "77.0900214", "orderAcceptStatus": "1", "riderEarningAmount": "92.00", "restaurant": {  "id": 5,  "name": "Burger King",  "deliveryTime": "15-20 min",  "address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India",  "phoneNumber": "8285392945",  "latitude": "28.562006",  "longitude": "77.2681095" }},{ "orderId": 100005, "deliveryCharges": "92.00", "tax": "19.00", "totalAmount": "330.00", "orderStatus": "In Prep", "orderStatusId": "4", "deliveryCode": "4391", "orderOn": 1628247984, "itemCount": 2, "itemList": {  {"itemName": "cocktail","itemCount": "4","itemPrice": "25.00"  },  {"itemName": "Test Item Name","itemCount": "3","itemPrice": "33.00"  } }, "address": "NMG Tech , Third Floor , Augusta Point , Gurugram", "latitude": "28.4474839", "longitude": "77.0900214", "orderAcceptStatus": "1", "riderEarningAmount": "92.00", "restaurant": {  "id": 5,  "name": "Burger King",  "deliveryTime": "15-20 min",  "address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India",  "phoneNumber": "8285392945",  "latitude": "28.562006",  "longitude": "77.2681095" }}  },  "pageData": {"total": 7,"per_page": 10,"current_page": 1,"last_page": 1  } }}
     *       )
     *  )
     *
     * 
     * 
     * 
     *  @OA\Schema(
     *      schema="rider_order_detail_success",
     *      example={ "code": 200, "message": "Order has been fetched", "data": {  "orderId": 100008,  "deliveryCharges": "92.00",  "tax": "19.00",  "totalAmount": "330.00",  "orderStatus": "In Prep",  "orderStatusId": "4",  "deliveryCode": "9583",  "orderOn": 1628248238,  "itemCount": 2,  "itemList": {{ "itemName": "cocktail", "itemCount": "4", "itemPrice": "25.00"},{ "itemName": "Test Item Name", "itemCount": "3", "itemPrice": "33.00"}  },  "address": "NMG Tech , Third Floor , Augusta Point , Gurugram",  "latitude": "28.4474839",  "longitude": "77.0900214",  "orderAcceptStatus": 1,  "riderEarningAmount": "92.00",  "restaurant": {"id": 5,"name": "Burger King","deliveryTime": "15-20 min","address": "Al-Bake, Maulana Mohammad Ali Jauhar Marg, Block A, New Friends Colony, New Delhi, Delhi, India","phoneNumber": "8285392945","latitude": "28.562006","longitude": "77.2681095"  } }}
     *       )
     *  )
     * 
     * 
     *
     * @OA\Post(
     *     path="/api/apply-rider",
     *     operationId="apply-rider",
     *     tags={"Rider"},
     *     summary="apply to become a rider ",
     *     description="apply to become a `rider`",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="age",
     *                     type="integer",
     *                 ),
     *                  @OA\Property(
     *                     property="id_proof",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="vehicle_information",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="driving_licence",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="bank",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="account_number",
     *                     type="string",
     *                 ),
     *
     *                 example={ "age":"25", "id_proof":"http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/images/BigBuckBunny.jpg", "vehicle_information":"http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/images/ElephantsDream.jpg", "driving_licence": "http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/images/ForBiggerBlazes.jpg", "bank":"Ecobank", "account_number":"12345674589" }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/apply_rider_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     * @OA\Put(
     *     path="/api/toggle-rider-status",
     *     operationId="toggle-rider-status",
     *     tags={"Rider"},
     *     summary="toggle rider status",
     *     description="**toggle rider status**",
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/apply_rider_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     *  @OA\Put(
     *     path="/api/rider/location",
     *     operationId="update-rider-location",
     *     tags={"Rider"},
     *     summary="Update rider current location",
     *     description="This api is used to update rider's current location frequently using `latitude` and `longitude`",
     *      @OA\Parameter(
     *         name="latitude",
     *         in="path",
     *         description="latitude",
     *         required=true,
     *         @OA\Schema(type="string")
     *     ),
     *  @OA\Parameter(
     *         name="longitude",
     *         in="path",
     *         description="longitude",
     *         required=true,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/update_current_location"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * 
     *  @OA\Get(
     *     path="/api/rider/orders?page={page}",
     *     operationId="get-rider-orders",
     *     tags={"Rider"},
     *     summary="Get rider orders",
     *     description="get rider orders.",
     *      @OA\Parameter(
     *         name="page",
     *         in="path",
     *         description="page",
     *         required=true,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/rider_order_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * 
     *  @OA\Get(
     *     path="/api/rider/order-details?orderId={orderId}",
     *     operationId="rider-order-details",
     *     tags={"Rider"},
     *     summary="Get order details",
     *     description="rider order details using `orderId`.",
     *      @OA\Parameter(
     *         name="orderId",
     *         in="path",
     *         description="orderId",
     *         required=true,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/rider_order_detail_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * @OA\Post(
     *     path="/api/rider/order/accept",
     *     operationId="rider_order_accept",
     *     tags={"Rider"},
     *     summary="Accept order using Order id",
     *     description="Accept order using `orderId`",
     *  @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="orderId",
     *                     type="numeric",
     *                 ),
     *                 example={"orderId": 100010}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/rider_order_accept_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *  
     * @OA\Post(
     *     path="/api/rider/order/reject",
     *     operationId="rider_order_reject",
     *     tags={"Rider"},
     *     summary="Reject order using order id & reason",
     *     description="Accept order using `orderId` & `reason`",
     *  @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="orderId",
     *                     type="numeric",
     *                 ),
     *                  @OA\Property(
     *                     property="reason",
     *                     type="string",
     *                 ),
     *                 example={"orderId": 100010,"reason": "Distance is too far"}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/rider_order_reject_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     * 
     * 
     * 
     * 
     * @OA\Post(
     *     path="/api/rider/order/complete",
     *     operationId="rider_order_complete",
     *     tags={"Rider"},
     *     summary="Complete order using order id & verificationCode",
     *     description="Complete order using `orderId` & `verificationCode`",
     *  @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="orderId",
     *                     type="numeric",
     *                 ),
     *                  @OA\Property(
     *                     property="verificationCode",
     *                     type="numeric",
     *                 ),
     *                 example={"orderId": 100010,"verificationCode": 1234}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/rider_order_complete_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     * 
     *  @OA\Get(
     *     path="/api/rider/earning",
     *     operationId="get-rider-earning",
     *     tags={"Rider"},
     *     summary="Get rider earnings",
     *     description="Get rider earnings.",
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/rider_earning_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     */
}
