<?php

namespace app\Http\Controllers\Documentation;

use app\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ApiAddressController extends Controller
{
    /**
     *
     *
     *
     *  @OA\Schema(
     *      schema="address_save_success",
     *      example={ "code": 200, "message": "Your address has been saved successfully", "data": {} }
     *       )
     *  )
     *
     *  @OA\Schema(
     *      schema="address_list_success",
     *      example={ "code": 200, "message": "Your addresses have been fetched", "data": { "addresses": { "meta": { "current_page": 1, "first_page_url": "http://localhost/bmf/api/user-address?page=1", "from": 1, "next_page_url": null, "per_page": 10, "prev_page_url": null, "to": 1, "total": 1, "more_pages": false }, "data": { { "id": 1, "user_id": "30", "contact_person": "Sumit Sharma", "address1": "Home first address", "address2": "Home Second Address", "city": "New Delhi", "state": "Delhi", "zipcode": "110044", "address_type": "Home", "latitude": null, "longitude": null, "country": "Ghana", "created_at": "2021-07-23T05:43:10.000000Z", "updated_at": "2021-07-23T05:43:10.000000Z" } } } } }
     *       )
     *  )
     *
     *
     *
     *
     *
     * @OA\Delete(
     *     path="/api/user-address/{addressId}",
     *     operationId="delete-user-address",
     *     tags={"User Address"},
     *     summary="Delete user address",
     *     description="Delete user address by `addressId`",
     *  @OA\Parameter(
     *         name="addressId",
     *         in="path",
     *         description="address Id",
     *         required=true,
     *         @OA\Schema(type="integer")
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/address_save_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     * @OA\Put(
     *     path="/api/user-address/{addressId}",
     *     operationId="put-user-address",
     *     tags={"User Address"},
     *     summary="update user address",
     *     description="Create user address. 1: `Home`, 2: `Work`, and  3: `Other` ",
     *  @OA\Parameter(
     *         name="addressId",
     *         in="path",
     *         description="address Id",
     *         required=true,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="address1",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="address2",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="city",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="state",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="zipcode",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="address_type",
     *                     type="integer",
     *                 ),
     *                  @OA\Property(
     *                     property="latitude",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="longitude",
     *                     type="string",
     *                 ),
     *
     *                 example={ "address1": "new Other address, just anywhere", "address2": "new Second Other address, rockon", "city":"ggn", "state": "Haryana", "zipcode": "120301", "address_type": 3,  "latitude":"28.459497", "longitude":"77.026634" }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/address_save_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *

     *
     *
     *
     * @OA\Get(
     *     path="/api/user-address",
     *     operationId="list-user-address",
     *     tags={"User Address"},
     *     summary="List user address",
     *     description="List user address.",     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/address_list_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     * @OA\Post(
     *     path="/api/user-address",
     *     operationId="store-user-address",
     *     tags={"User Address"},
     *     summary="Create user address",
     *     description="Create user address. 1: `Home`, 2: `Work`, and  3: `Other` ",
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                  @OA\Property(
     *                     property="address1",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="address2",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="city",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="state",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="zipcode",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="address_type",
     *                     type="integer",
     *                 ),
     *                  @OA\Property(
     *                     property="latitude",
     *                     type="string",
     *                 ),
     *                  @OA\Property(
     *                     property="longitude",
     *                     type="string",
     *                 ),
     *
     *                 example={ "address1": "new Other address, just anywhere", "address2": "new Second Other address, rockon", "city":"ggn", "state": "Haryana", "zipcode": "120301", "address_type": 3, "latitude":"28.459497", "longitude":"77.026634" }
     *             )
     *         )
     *     ),
     *
     *     @OA\Response(
     *         response="200",
     *         description="sucess.",
     *         @OA\JsonContent(ref="#/components/schemas/address_save_success"),
     *     ),
     *     @OA\Response(
     *         response="400",
     *         description="Error: Bad request.",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *     @OA\Response(
     *         response="401",
     *         description="unauthorised access.",
     *          @OA\JsonContent(ref="#/components/schemas/authentication_error"),
     *     ),
     *     @OA\Response(
     *         response="422",
     *         description="validation error",
     *          @OA\JsonContent(ref="#/components/schemas/bad_request"),
     *     ),
     *      security={{"bearerAuth":{}}},
     * )
     *
     *
     *
     *
     */

}
