<?php

namespace app\Http\Controllers\Api\V1;

use app\Http\Controllers\Api\V1\BaseController;
use app\Model\Admin\StaticPage;
use Illuminate\Http\Request;

class StaticPagesController extends BaseController
{

    public function __construct()
    {

    }

    /**
     * @Author:: NMG
     * @Function::show
     * @Input: slug parameter
     * @Description:: This function will return static pages detail.
     * @Dated:: 27/Dec/2019
     * @updated:: 27/Dec/2019
     */
    public function show(Request $request, $slug)
    {
        try {

            if (!empty($slug)) {
                $staticPage = StaticPage::where(['slug'=>$slug])->first();

                if (!empty($staticPage)) {
                    $this->dataList['url'] = url($slug);
                    // $this->dataList['htmlTitle'] = $staticPage->title;
                    // $this->dataList['content'] = $staticPage->content;
                    $this->code = config('api.constants.httpCodes.SUCCESS');
                    $this->message = __('api/validation/static-pages.success.viewResult');
                } else {
                    $this->dataList = [];
                    $this->code = config('api.constants.httpCodes.ERROR');
                    $this->message = __('api/validation/static-pages.error.viewResult');
                }
            }
            return $this->sendResponse();
        } catch (\Exception $exception) {
            $this->saveErrorLog($exception);
            $this->code = config('api.constants.httpCodes.SERVER_ERROR');
            $this->message = __('api/common.SERVER_ERROR');
            return $this->sendError();
        }
    }
}
