<?php

namespace app\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use app\Model\Api\V1\Restaurant;
use app\Model\Api\V1\User;
use app\Model\Api\V1\RestaurantMenu;
use Illuminate\Support\Facades\Auth;
use app\Transformers\AddressTransformer;
use Illuminate\Support\Facades\Validator;
use app\Transformers\RestaurantTransformer;
use app\Http\Controllers\Api\V1\BaseController;
use app\Transformers\RestaurantMenuTransformer;

class RestaurantMenuController extends BaseController
{
    /**
     * private variable address
     *
     * @var [object]
     */
    private $menu;

    /**
     * constructor of class.
     *
     * @param Menu $menu
     */
    public function __construct(RestaurantMenu $menu)
    {
        $this->menu = $menu;
    }



    public function index(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                if ($request->isJson()) {
                    $input = $request->json()->all();
                } else {

                    $input = $request->all();
                }
                if (!empty($input['request'])) {
                    //encrypted input request
                    $encrypted = $input['request'];
                    $decrypted = $this->apiEncryption('decrypt', $encrypted);
                    $input = (array) json_decode($decrypted);
                } else {
                    $input = $request->only(['latitude', 'longitude', 'restaurantId']);
                }
                // server side validations
                $validator = Validator::make($input, RestaurantMenu::rules(), RestaurantMenu::messages());
                if ($validator->fails()) {
                    $this->code = config('api.constants.httpCodes.ERROR');
                    $this->message = $validator->errors()->first();
                } else {
                    $user =  Auth::user();
                   // if (empty($user)) {
                       // $this->code = config('api.constants.httpCodes.ERROR');
                      //  $this->message = __('api/validation/user.mobile_no.exists');
                   // } else {
                       // if ($user->status == 1) {
                            $restaurantData = Restaurant::get($input['restaurantId']);
                            // create a new array
                            if (!empty($restaurantData)) {
                                // check if restaurant is online
                                if ($restaurantData->user->is_active == 1) {
                                    // create new array of restaurant
                                    $this->dataList['restaurant'] =  (new RestaurantTransformer)->transform($restaurantData, false);
                                    // get menu list
                                    $categories = $this->dataList['restaurant']['categoryTypes'];
                                    $i = 0;
                                    $this->dataList['menuList'] = [];
                                    foreach ($categories as $category) {
                                        $items = RestaurantMenu::list($request, $restaurantData->id, $category->id);
                                        $this->dataList['menuList'][$i]['foodCategory'] = $category->name;
                                        $this->dataList['menuList'][$i]['count'] = $items->count();
                                        $this->dataList['menuList'][$i]['item'] = (new RestaurantMenuTransformer)->collection($items, false);
                                        // dd($items);
                                        $i++;
                                    }
                                    // $menuList = RestaurantMenu::getList();
                                    $this->code = config('api.constants.httpCodes.SUCCESS');
                                    $this->message = __('api/validation/restaurant.success.fetch');
                                } else {
                                    $this->dataList['restaurants'] = [];
                                    $this->code = config('api.constants.httpCodes.ERROR');
                                    $this->message = __('api/validation/restaurant.error.offline');
                                }
                            } else {
                                $this->dataList['restaurants'] = [];
                                $this->code = config('api.constants.httpCodes.ERROR');
                                $this->message = __('api/validation/restaurant.error.fetch');
                            }
                     //   } else {
                       //     $this->code = config('api.constants.httpCodes.FORBIDDEN');
                        //    $this->message = __('api/validation/user.error.blocked');
                     //  }
                    //}
                }
                return $this->sendResponse();
            }
        } catch (\Exception $exception) {
            return $exception;
            $this->saveErrorLog($exception);
            return $this->sendError($exception);
        }
    }
}
