<?php

namespace app\Http\Controllers\Api\V1;

use app\Http\Controllers\Api\V1\BaseController;
// use app\Http\Controllers\Api\V1\PubNubChatController;
// use app\Model\Api\V1\User;
use app\Model\Api\V1\Restaurant;
// use app\Model\Api\V1\FcmToken;
// use app\Model\Api\V1\Messages;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
// use app\Components\Api\PushNotification;
// use app\Model\Api\V1\Notification;
// use Carbon\Carbon;
// use Illuminate\Support\Facades\DB;
use app\Traits\DistanceCalculatorTrait;
use app\Model\Admin\GeneralSetting;
use app\Model\Api\V1\FoodCategory;


class RestaurantController extends BaseController
{

    /**
     * Author: Jaidev
     * Function: getRestaurant
     * Description: User can search restaurant
     * Input:  restaurant_type [1=>local , 2=>continent , 3=>groceries],lat , long , categoryId , searchString
     * Output: Restaurant list as per the request
     * Dated:19/July/2021
     */

    public function restaurantList(Request $request)
    {
        // dd($request->all());
        try {
            if ($request->isMethod('get')) {
                if ($request->isJson()) {
                    $input = $request->json()->all();
                } else {

                    $input = $request->all();
                }
                $imageHeight = request()->header('height');
                $imageWidth = request()->header('width');

                if (!empty($input['request'])) {
                    //encrypted input request
                    $encrypted = $input['request'];
                    $decrypted = $this->apiEncryption('decrypt', $encrypted);
                    $input = (array) json_decode($decrypted);
                } else {
                    $input = $request->only(['latitude', 'longitude', 'type', 'categoryId', 'page', 'searchString']);
                }
                // server side validations
                $validator = Validator::make($input, Restaurant::rules(), Restaurant::messages());
                if ($validator->fails()) {
                    $this->code = config('api.constants.httpCodes.ERROR');
                    $this->message = $validator->errors()->first();
                } else {
                    //$user = $user = Auth::user();
                   // if (empty($user)) {
                     //   $this->code = config('api.constants.httpCodes.ERROR');
                     //   $this->message = __('api/validation/user.mobile_no.exists');
                   // } else {
                        // return $user->id;
                       // if ($user->status == 1) {
                            $restaurantDataList = Restaurant::getRestaurant($request);
                            $this->dataList['pageData']['total'] = (int) $restaurantDataList->total();
                            $this->dataList['pageData']['per_page'] = (int) $restaurantDataList->perPage();
                            $this->dataList['pageData']['current_page'] = (int) $restaurantDataList->currentPage();
                            $this->dataList['pageData']['last_page'] = (int) $restaurantDataList->lastPage();

                            // create a new array
                            if (!empty($restaurantDataList)) {
                                // create new array of restaurant
                                $this->dataList['foodCategoryList'] = $this->foodCategoryDataFormat(FoodCategory::list());
                                //echo "<pre>@@@"; print_r($this->dataList['foodCategoryList']); exit;
                                $this->dataList['restaurants'] = $this->restaurantApiDataFormat($input, $restaurantDataList);
                                $this->code = config('api.constants.httpCodes.SUCCESS');
                                $this->message = __('api/validation/restaurant.success.fetch');
                            } else {
                                $this->dataList['restaurants'] = [];
                                $this->code = config('api.constants.httpCodes.ERROR');
                                $this->message = __('api/validation/restaurant.error.fetch');
                            }
                        // } else {
                           // $this->code = config('api.constants.httpCodes.FORBIDDEN');
                           // $this->message = __('api/validation/user.error.blocked');
                      //  }
                    //}
                }
                return $this->sendResponse();
            }
        } catch (\Exception $exception) {
            $this->saveErrorLog($exception);
            return $this->sendError($exception);
        }
    }


    public static function restaurantApiDataFormat($input, $data)
    {
        $resp = [];
        $fixedDeliveryCharge = GeneralSetting::getDeliveryCharges();
        $perMileCharges = GeneralSetting::getMileCharges();
        $imageHeight = request()->header('height');
        $imageWidth = request()->header('width');
        $i = 0;
        foreach ($data as $d) {
            $resp[$i]['id'] = $d->id;
            $resp[$i]['name'] = $d->name;
            $restType = [];
            if ($d->resturent_type_local == 1) {
                $restType[] = 1;
            }
            if ($d->resturent_type_continental == 1) {
                $restType[] = 2;
            }
            if ($d->resturent_type_groceries == 1) {
                $restType[] = 3;
            }
            $resp[$i]['restaurantType'] = implode(',', $restType);
            $resp[$i]['deliveryTime'] = (!empty($d->delivery_time) ? $d->delivery_time . ' min' : '15-30 min');
            $resp[$i]['latitude'] = $d->latitude;
            $resp[$i]['longitude'] = $d->longitude;
            $resp[$i]['distanceDB'] = $d->distanceInRange;

            $resp[$i]['distance'] = DistanceCalculatorTrait::distanceOneToOne($input['latitude'], $input['longitude'], $d->latitude, $d->longitude);
            $resp[$i]['deliveryFee'] =  \app\Helpers\CommonHelper::calculateDeliveryFees($resp[$i]['distance']);

            if (!empty($imageHeight) || !empty($imageWidth)) {
                $resp[$i]['restaurantImage'] = (!empty($d->user->latestAvatar->avatar) ? \app\Helpers\ResizeImagesHelper::resizeImage($d->user->latestAvatar->avatar) : null);
            } else {
                $resp[$i]['restaurantImage'] = (!empty($d->user->latestAvatar) ?  $d->user->latestAvatar->avatar : null);
            }
            $foodCat = Restaurant::getDistinctFoodCategories($d->id);
            $resp[$i]['categoryTypes'] = $foodCat;
            $i++;
        }
        return $resp;
    }

    public static function foodCategoryDataFormat($data)
    {
        $resp = [];
        $imageHeight = request()->header('height');
        $imageWidth = request()->header('width');
        $i = 0;

        if (isset($data[0])) {
            foreach ($data as $value) {
                $resp[$i]['id'] = $value->id;
                $resp[$i]['name'] = $value->name;
                if (!empty($imageHeight) || !empty($imageWidth)) {
                    $resp[$i]['image'] = (!empty($value->image) ? \app\Helpers\ResizeImagesHelper::resizeImage($value->image) : null);
                } else {
                    $resp[$i]['image'] = (!empty($value->image) ?  $value->image : null);
                }
                $i++;
            }
        }
        return $resp;
    }
}
