<?php

namespace app\Http\Controllers\Api\V1;

use app\Model\Api\V1\Order;
use Illuminate\Http\Request;
use app\Helpers\CommonHelper;
use app\Model\Api\V1\OrderItem;
use app\Model\Api\v1\Restaurant;
use app\Model\Api\V1\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use app\Transformers\OrderTransformer;
use Illuminate\Support\Facades\Validator;
use app\Http\Controllers\Api\V1\BaseController;


class OrderController extends BaseController
{
    /**
     * private variable address
     *
     * @var [object]
     */
    private $order;

    /**
     * constructor of class.
     *
     * @param Order $order
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {
            if ($request->user()->status == 1) {

                $request->request->add(['userId' => $request->user()->id]);
                $orderList =  $this->order->list($request);
                if (!empty($orderList)) {
                    $transformData = (new OrderTransformer)->collection($orderList, false);
                    $this->dataList['orderCount'] = $orderList->count();
                    $this->dataList['orders'] = $transformData->data;
                    $this->dataList['pageData']['total'] = (int) $orderList->total();
                    $this->dataList['pageData']['per_page'] = (int) $orderList->perPage();
                    $this->dataList['pageData']['current_page'] = (int) $orderList->currentPage();
                    $this->dataList['pageData']['last_page'] = (int) $orderList->lastPage();
                    $this->code    = config('api.constants.httpCodes.SUCCESS');
                    $this->message = __('api/validation/order.success.fetch');
                } else {
                    $this->dataList = [];
                    $this->code    = config('api.constants.httpCodes.SUCCESS');
                    $this->message = __('api/validation/order.error.empty');
                }
            } else {
                $this->code = config('api.constants.httpCodes.FORBIDDEN');
                $this->message = __('api/validation/user.error.blocked');
            }
            return $this->sendResponse();
        } catch (\Throwable $th) {
            return $th;
            return $this->processError($th);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function details(Request $request, $orderId)
    {
        //
        try {
            if ($request->user()->status == 1) {
                $request->request->add(['userId' => $request->user()->id]);
                $orderData =  $this->order->details($request, $orderId);
                // dd($orderData);

                if (!empty($orderData)) {
                    $transformData = (new OrderTransformer)->transform($orderData, false);
                    $this->dataList = $transformData;
                    $this->code    = config('api.constants.httpCodes.SUCCESS');
                    $this->message = __('api/validation/order.success.fetch');
                } else {
                    $this->dataList = [];
                    $this->code    = config('api.constants.httpCodes.SUCCESS');
                    $this->message = __('api/validation/order.error.empty');
                }
            } else {
                $this->code = config('api.constants.httpCodes.FORBIDDEN');
                $this->message = __('api/validation/user.error.blocked');
            }
            return $this->sendResponse();
        } catch (\Throwable $th) {
            // return $th;
            return $this->processError($th);
        }
    }



    public function cancel(Request $request)
    {
        // return $request;
        //
        try {
            $input = $request->all();
            // validate request
            $validator = Validator::make($input, Order::cancelRules(), Order::messages());
            if ($validator->fails()) {
                $this->code = config('api.constants.httpCodes.ERROR');
                $this->message = $validator->errors()->first();
                return $this->sendResponse();
            }
            if ($request->user()->status == 1) {

                $request->request->add(['userId' => $request->user()->id]);
                $orderId = $input['orderId'];
                $orderData =  Order::find($orderId);
                // return $orderData;
                if (!empty($orderData)) {
                    if ($orderData->user_id == $request->user()->id) {
                        if ($orderData->order_status_id == config('admin.constants.ORDER_STATUS_PENDING')) {
                            $orderData->order_status_id = config('admin.constants.ORDER_STATUS_CANCELED'); // cancel
                            $orderData->save();


                            // send notification to restaurant
                            $restaurant = Restaurant::find($orderData->restaurant_id);
                            $notification['title'] = 'Order cancelled';
                            $notification['description'] = 'Order no #' . $orderData->id . ' has been cancelled by customer';
                            $notification['order_id'] = $orderData->id;
                            $notification['user_id'] = $restaurant->owner_id;
                            Notification::create($notification);
                            if (!empty($request->user()->email)) {

                                ### Email Sending #####
                                if (!empty($input['lang'])) {
                                    \App::setLocale($input['lang']);
                                }
                                $params['replaceKeywords']['{USER_NAME}'] = $orderData['firstname'] . ' ' . $orderData['lastname'];
                                $params['replaceKeywords']['{ORDER_ID}'] = $orderData->id;
                                $params['replaceKeywords']['{AMOUNT}'] = $orderData['total_amount'];
                                $params['replaceKeywords']['{DELIVER_TO}'] = $orderData['firstname'] . ' ' . $orderData['lastname'];
                                $params['replaceKeywords']['{ADDRESS}'] = $orderData['address1'];
                                $params['replaceKeywords']['{ADDRESS_TYPE}'] = CommonHelper::getAddressType($orderData['address_type']);
                                $params['toEmail'] = $request->user()->email;
                                $params['emailSlug'] = 'customer_restaurant_due_nonavailability_cancle_order';
                                if (!$this->customMailer($params)) {
                                    DB::rollBack();
                                    return $this->processError('failed to send mail');
                                }
                            }

                            $this->dataList = [];
                            $this->code    = config('api.constants.httpCodes.SUCCESS');
                            $this->message = __('api/validation/order.success.canceled');
                        } else {
                            $this->dataList = [];
                            $this->code    = config('api.constants.httpCodes.ERROR');
                            $this->message = __('api/validation/order.error.canceled');
                        }
                    } else {
                        $this->dataList = [];
                        $this->code    = config('api.constants.httpCodes.ERROR');
                        $this->message = __('api/validation/order.error.invalidUser');
                    }
                } else {
                    $this->dataList = [];
                    $this->code    = config('api.constants.httpCodes.SUCCESS');
                    $this->message = __('api/validation/order.error.empty');
                }
            } else {
                $this->code = config('api.constants.httpCodes.FORBIDDEN');
                $this->message = __('api/validation/user.error.blocked');
            }
            return $this->sendResponse();
        } catch (\Throwable $th) {
            // return $th;
            return $this->processError($th);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        //
    }
}
