<?php

namespace app\Http\Controllers\Api\V1;

use app\Http\Controllers\Api\V1\BaseController;

use app\Model\Api\V1\Notification;
use app\Transformers\NotificationTransformer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use app\Model\Api\V1\FcmToken;
use app\Model\Api\V1\User;
use App\Components\Api\V1\PushNotification;
use Illuminate\Support\Facades\Validator;


class NotificationController extends BaseController
{
    public function index(Request $request, Notification $notification)
    {
        try {
            if ($request->user()->status == 1) {
                if ($request->isMethod('get')) {
                    $request->request->add(['userId' => $request->user()->id]);
                    $notificationsData                  = $notification->list($request);
                    if ($notificationsData->count() > 0) {
                        $this->dataList['notifications'] = (new NotificationTransformer)->collection($notificationsData);
                        $msg = __('api/notification.success.101');
                    } else {
                        $this->dataList['notifications'] = (object) [];
                        $msg = __('api/notification.error.201');
                    }
                    $this->code = config('api.constants.httpCodes.SUCCESS');
                    $this->message = $msg;
                } else {
                    $this->code = config('api.constants.httpCodes.ERROR');
                    $this->message = __('api/validation/user.error.blocked');
                }
            } else {
                $this->code = config('api.constants.httpCodes.FORBIDDEN');
                $this->message = __('api/validation/user.error.blocked');
            }
            return $this->sendResponse();
        } catch (\Throwable $th) {
            return $this->processError($th);
        }
    }

    public function pushNotificationParameter($user_id, $parameter)
    {
        if (!empty($user_id)) {
            $token = FcmToken::select('fcm_tokens.user_id', 'fcm_tokens.fcm_token', 'users.notification_status')
                ->join('users', 'fcm_tokens.user_id', '=', 'users.id')
                ->where('fcm_tokens.user_id', $user_id)
                ->where('users.notification_status', '1')->get();
            return $token;
        }
        if (!empty($token)) {
            $a = array();
            $u_id = array();
            $i = 0;
            foreach ($token as $t) {

                $a[$i] = $t->fcm_token;
                $u_id[$i] = $t->user_id;
                $i++;
            }
            $ids = $a;
            $data = [
                "registration_ids" => $ids,
                "data" => $parameter
            ];

            $dataString = json_encode($data);

            return  $this->pushNotificationConfig($dataString);
        }
    }



    public function markRead(Request $request)
    {
        try {
            if ($request->isMethod('put')) {
                $validation = Validator::make($request->all(), Notification::rules(), Notification::messages());
                if ($validation->fails()) {
                    $this->httpCode = config('api.constants.httpCodes.SUCCESS');
                    $this->code     = config('api.constants.httpCodes.ERROR');
                    $this->message  = $validation->errors()->first();
                    return $this->sendResponse();
                }
                $input = $request->all();
                $notification = Notification::find($input['id']);
                $notification->is_read = 1;



                if ($notification->save()) {
                    $this->dataList = [];
                    $this->code     = config('api.constants.httpCodes.SUCCESS');
                    $this->message  = "Notification marked read successfully";
                } else {
                    $this->code    = config('api.constants.httpCodes.ERROR');
                    $this->message = 'Unable to mark read notification';
                }
                return $this->sendResponse();
            }
        } catch (\Throwable $th) {
            return $this->processError($th);
        }
    }
}
