<?php

namespace app\Http\Controllers\Api;

use app\Http\Controllers\Api\BaseController;
use app\Model\Api\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MedicalWorkers extends BaseController
{
    /**
     * @Author:: NMG
     * @Function::__invoke
     * @Input: optional parameters- page, limit, q(searchString)
     * @Description:: This function will return medical workers list defualt & as per search term
     * @Output:: A list of medical workers as per search string
     * @Dated:: 19/Dec/2019
     * @updated:: 20/Dec/2019
     */
    public function __invoke(Request $request)
    {
        try {
            $authUser = Auth::user();
            $auth_id = $authUser->id;
            $roleId = config('admin.constants.PUBLIC_USERS_ROLE');

            $page = $request->query('page', 1);
            $limit = $request->query('limit', config('api.constants.DEFAULT_PAGE_LIMIT'));
            $this->const['page'] = $page;
            $this->const['limit'] = $limit;

            $searchString = filter_var($request->q, FILTER_SANITIZE_STRING);
            $facilityId = filter_var($request->fs, FILTER_VALIDATE_INT);
            $facilityId = (!empty($facilityId)) ? $facilityId : $authUser->facility_id;
            $departmentId = filter_var($request->dept, FILTER_VALIDATE_INT);
            //Normal department list
            $query = User::select(
                'users.id',
                'users.user_name',
                'users.first_name',
                'users.last_name',
                \DB::raw('CONCAT(users.first_name, " ", users.last_name) AS full_name'),
                'users.email',
                'users.profile_image',
                'users.facility_id',
                'users.department_id',
                'users.title_id'
            )->with('departments')->where([['status', '=', 1], ['role_id', '=', $roleId], ['users.id', '!=', $auth_id]]);
            if (!empty($facilityId)) {
                $query->where('users.facility_id', $facilityId);
            }
            if (!empty($departmentId)) {
                $query->where('users.department_id', $departmentId);
            }
            if (!empty($searchString)) {
                $query->where(function ($q) use ($searchString) {
                    $q->orWhere('users.first_name', 'like', "%{$searchString}%");
                    $q->orWhere('users.last_name', 'like', "%{$searchString}%");
                });
            }
            //discard user's whom i have blocked
            $query->whereNotIn('id', function ($query) use ($auth_id) {
                $query->select('user_id')
                    ->from('blocked_users')
                    ->where('blocked_by', $auth_id)
                    ->where('status', 1);
            });
            ##### pagination :: starts #########
            if ($limit == -1) {
                //fetch all records
                $users = $query->latest()->paginate();
            } else {
                $users = $query->latest()->paginate($limit);
            }

            $total = $users->total();
            $pageLimit = $users->perPage();
            $currentPage = $users->currentPage();
            $lastPage = $users->lastPage();
            ##### pagination :: ends #########

            if (!empty($users)) {
                foreach ($users as $key => $user) {

                    if(!empty($user->departments)){
                        foreach($user->departments as $keys => $dept){

                            $this->dataList['departments'][$keys]['departmentId'] = !empty($dept->id) ? $dept->id : null;
                            $this->dataList['departments'][$keys]['departmentParentId'] = !empty($dept->parent_id) ? $dept->parent_id : null;
                            $this->dataList['departments'][$keys]['departmentName'] = !empty($dept->name) ? $dept->name : null;

                        }
                    }

                    $this->dataList['users'][$key]['profile']['userId'] = $user->id;
                    $this->dataList['users'][$key]['profile']['userName'] = $user->user_name;
                    $this->dataList['users'][$key]['profile']['fullName'] = $user->full_name;
                    $this->dataList['users'][$key]['profile']['email'] = $user->email;
                    $avatarImage = self::userAvatar($user->id);
                    $this->dataList['users'][$key]['profile']['userImage'] = $avatarImage;

                    $title = \app\Model\Admin\Title::select('name')->where('id', $user->title_id)->first();
                    if (!empty($title->name)) {
                        $this->dataList['users'][$key]['profile']['titleId'] = (int) $user->title_id;
                        $this->dataList['users'][$key]['profile']['titleName'] = $title->name;
                    } else {
                        $this->dataList['users'][$key]['profile']['titleId'] = '';
                        $this->dataList['users'][$key]['profile']['titleName'] = '';
                    }
                    $this->dataList['users'][$key]['profile']['departmentId'] = (int) $user->department_id;
                    $dept = \app\Model\Admin\Department::select('name')->where('id', $user->department_id)->first();
                    if (!empty($dept->name)) {
                        $this->dataList['users'][$key]['profile']['departmentName'] = $dept->name;
                    } else {
                        $this->dataList['users'][$key]['profile']['departmentName'] = '';
                    }
                    $facility = \app\Model\Admin\Facility::select('id', 'uuid', 'name', 'color_code')->where('id', $user->facility_id)->first();
                    if ($facility) {
                        $this->dataList['users'][$key]['facility']['facilityId'] = (int) $facility->id;
                        $this->dataList['users'][$key]['facility']['facilityUuid'] = $facility->uuid;
                        $this->dataList['users'][$key]['facility']['facilityTitle'] = $facility->name;
                        $this->dataList['users'][$key]['facility']['facilityColor'] = (!empty($facility->color_code)) ? '#' . $facility->color_code : getConfig('facility-default-color');
                        $logo = self::facilityImage($facility->id);
                        $this->dataList['users'][$key]['facility']['facilityLogo'] = $logo;

                    } else {
                        $this->dataList['users'][$key]['facility'] = null;
                    }

                }
                $this->dataList['total'] = (int) $total;
                $this->dataList['per_page'] = (int) $pageLimit;
                $this->dataList['current_page'] = (int) $currentPage;
                $this->dataList['last_page'] = (int) $lastPage;

                $this->code = config('api.constants.httpCodes.SUCCESS');
                $this->message = __('api/validation/user.success.mwList');
            } else {
                $this->dataList['facilities'] = [];
                $this->code = config('api.constants.httpCodes.ERROR');
                $this->message = __('api/validation/user.error.mwList');
            }

            return $this->sendResponse();
        } catch (\Exception $exception) {
            $this->saveErrorLog($exception);
            $this->code = config('api.constants.httpCodes.SERVER_ERROR');
            $this->message = __('api/common.SERVER_ERROR');
            return $this->sendError();
        }
    }
}
