<?php

namespace app\Http\Controllers\Api\V1;

use app\Http\Controllers\Api\V1\BaseController;
use Illuminate\Http\Request;
use app\Model\Admin\UpdateApp;
use app\Transformers\ForceUpdateTransformer;
use DB;

class ForceUpdateController extends BaseController
{

    public function __construct()
    {

    }

    /**
     * @Author:: Bibhash Shishodiya
     * @Function::forceUpdate
     * @Input: slug parameter
     * @Description:: This function will return application version detail.
     * @Dated:: 26/Aug/2021
     * @updated:: 26/Aug/2021
     */
    public function forceUpdate(Request $request)
    {
        try {
              $versionData = array();
              $data = UpdateApp::first();
              if($data){
                    $versionData= [
                        "androidVersion"  => $data->android_version,
                        "iosVersion"      => $data->ios_version,
                        "forceUpdateAndroid" => (int)$data->force_update_android,
                        "forceUpdateIos"    => (int)$data->force_update_ios,
                        "androidMessage"    =>  $data->android_update_message,
                        "iosMessage"    =>  $data->ios_update_message,
                    ];   
               }
               $this->dataList = $versionData;
               $this->code     = config('api.constants.httpCodes.SUCCESS');
               $this->message  = __('api/validation/static-pages.success.forceUpdate');
              
            return $this->sendResponse();
        } catch (\Exception $exception) {
            $this->saveErrorLog($exception);
            return $this->sendError($exception);
        }
    }
}
