<?php

namespace app\Http\Controllers\Api\V1;

use app\Http\Controllers\Api\V1\BaseController;
use app\Model\Api\User;
use app\Model\Api\V1\ContactSupport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ContactSupportController extends BaseController
{
    /**
     * Author: NMG
     * Function: store
     * Description: contact support store record and send mail to facility administator
     * Input: ['message']
     * Output: json response of message sent
     * Dated: 27/Dec/2019
     */
    public function store(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                $user  = $request->user();
                $input = $request->all();
                //server side validations
                $validation = Validator::make($input, ContactSupport::rules(), ContactSupport::messages());
                if ($validation->fails()) {
                    $this->httpCode = config('api.constants.httpCodes.SUCCESS');
                    $this->code     = config('api.constants.httpCodes.ERROR');
                    $this->message  = $validation->errors()->first();
                    return $this->sendResponse();
                }
                if ($request->user()->status == 1) {

                    if ($request->has('restaurant_id') && !empty($request->restaurant_id)) {
                        ContactSupport::create([
                            'user_id' => $request->user()->id,
                            'title' => $request->title,
                            'message'   => $request->message,
                            'restaurant_id' => $request->restaurant_id,
                        ]);
                    }

                    $supportEmail = getConfig('support-mail');


                    if (empty($supportEmail)) {
                        $this->code    = config('api.constants.httpCodes.ERROR');
                        $this->message = __('api/validation/contact-support.error.email');
                        return $this->sendResponse();
                    }
                    ###send support Email#####
                    if (!empty($input['lang'])) {
                        \App::setLocale($input['lang']);
                    }
                    $params['replaceKeywords']['{USER_NAME}'] = ucwords($user->first_name . ' ' . $user->last_name);
                    $params['replaceKeywords']['{TITLE}']     = $input['title'];
                    $params['replaceKeywords']['{MESSAGE}']   = $input['message'];
                    $params['toEmail']                        = $supportEmail;
                    $params['emailSlug']                      = 'contact_email';

                    $this->customMailer($params);
                    ######## End Contact us email to admin only  ###########


                    $this->code    = config('api.constants.httpCodes.SUCCESS');
                    $this->message = __('api/validation/contact-support.success.sentMessage');
                } else {
                    $this->code = config('api.constants.httpCodes.FORBIDDEN');
                    $this->message = __('api/validation/user.error.blocked');
                }

                return $this->sendResponse();
            }
        } catch (\Exception $exception) {
            return $this->processError($exception);
        }
    }
}
