<?php

namespace app\Http\Controllers\Api\V1;

use app\Model\Api\V1\User;
use app\Http\Controllers\Controller;
use app\Components\Api\V1\PushNotification;

#use Jenssegers\Agent\Agent;

class BaseController extends Controller
{
    protected $dataList;
    protected $httpCode;
    protected $code;
    protected $message;

    public function __construct()
    {
        $this->dataList = [];
        $this->httpCode = 2004;
        $this->code = 200;
        $this->message = '';
    }

    public function testPushNotification($receiver_id = null)
    {
        if (empty($receiver_id)) {
            return false;
        }

        $user = User::select('id', 'user_name')
            ->with([
                'avatars' => function ($query) {
                    $query->select('id', 'user_id', 'avatar')->latest('id')->first();
                },
            ])
            ->where('id', $receiver_id)->first();
        //echo '<pre>';print_r($user->avatars[0]->id);die;
        if (!empty($user)) {

            $notificationData = [
                'notifiable_id' => $user->id,
                'receiver_id' => $user->id,
                'bold_string' => $user->user_name,
                'replaced_array' => [$user->user_name, env('APP_NAME')],
                'left_image_id' => null,
                'right_image_id' => $user->id,
            ];

            $sent = PushNotification::triggerPush(config('api.notification.TYPE_ID.USER.WELCOME.CODE'), $notificationData);

            if (!empty($sent)) {
                $this->message = __('api/notification.success.notificationSent');
                return $this->sendResponse();
            } else {
                $this->message = __('api/notification.error.notificationSent');
                return $this->sendError();
            }
        } else {
            $this->message = __('api/notification.error.userNotFound');
            return $this->sendError();
        }
    }

    /**
     * Author: NMG
     * Function: sendResponse
     * Description: json response to api calls and the data will be encrypted using private shared key
     * Dated: 17/July/2021
     */
    public function sendResponse()
    {
        if (env('API_ENCRYPTION')) {
            $string = json_encode($this->dataList);
            $result = $this->apiEncryption('encrypt', $string);
        } else {
            $result = (object) $this->dataList;
            if ((int) $this->code == 400) {
                $result = (object) [];
            }
        }
        $this->httpCode = config('api.constants.httpCodes.SUCCESS');
        $response = [
            'code' => (int) $this->code,
            'message' => $this->message,
            'data' => $result,
        ];
        return response()->json($response, (int) $this->httpCode);
    }

    /**
     * Author: NMG
     * Function: sendError
     * Description: json response to api call in case of application error
     * Dated: 17/July/2021
     */
    public function sendError($exception = null)
    {
        $this->httpCode = config('api.constants.httpCodes.SERVER_ERROR');
        $this->code = config('api.constants.httpCodes.SERVER_ERROR');
        if (!empty($exception) && $exception->getCode() == (int) __('api/common.EXCEPTION.ENCRYPTION.code')) {
            $this->message = $exception->getMessage();
        }

        $response = [
            'code' => (int) $this->code,
            'message' => $this->message,
            'data' => (object) $this->dataList,
        ];
        return response()->json($response, (int) $this->httpCode);
    }

    /**
     * Author: NMG
     * Function: generatePIN
     * Description:generate random n number digit long pin
     * Input: ['number)', 'Int']
     * Output: return random n length number
     * Dated: 17/July/2021
     */

    public static function generatePIN($digits)
    {
        $i = 0;
        $pin = "";
        while ($i < $digits) {

            $pin .= mt_rand(0, 9);
            $i++;
        }
        return $pin;
    }
    /**
     * handle catch error
     *
     * @param [object] $exception
     * @return $this
     */
    public function processError($exception)
    {
        $this->saveErrorLog($exception);
        $this->httpCode = config('api.constants.httpCodes.SERVER_ERROR');
        $this->code = config('api.constants.httpCodes.SERVER_ERROR');
        $this->message = __('api/common.SERVER_ERROR');
        return $this->sendError();
    }
}
