<?php

namespace app\Http\Controllers\Api\V1;

use app\Helpers\CommonHelper;
use app\Http\Controllers\Api\V1\BaseController;
use app\Model\Api\V1\FcmToken;
use app\Model\Api\V1\User;
use app\Traits\FilePathUrl;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Twilio\Rest\Client;
use app\Model\Api\V1\DeliveryPerson;

class AuthController extends BaseController
{
    use FilePathUrl;

    public function __construct()
    {
        parent::__construct();
    }
    /**
     * @Method: login()
     * @Scope: public
     * @Input: @email, @password
     * @returns: json object
     * @Description: sed Laravel passport authentication, return user datils & access token
     * @Dated 17/July/2021
     * @Updated 20/Apr/2022
     */

    public function login(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                if ($request->isJson()) {
                    $input = $request->json()->all();
                } else {
                    $input = $request->all();
                }

                if (!empty($input['request'])) {
                    //if input request get in form of encrypted string then decrypt it before use
                    $encrypted = $input['request'];
                    $decrypted = $this->apiEncryption('decrypt', $encrypted);
                    $input     = (array) json_decode($decrypted);
                } else {
                    //normal request
                    $input = Input::only('phone', 'password', 'deviceToken', 'deviceType');
                }
                //server side validations
                $validator = Validator::make($input, User::loginRules(), User::messages());
                if ($validator->fails()) {
                    $this->code    = config('api.constants.httpCodes.ERROR');
                    $this->message = $validator->errors()->first();
                    return $this->sendResponse();
                }
                //echo "<pre>@@@"; print_r($input); exit;
                //check authentication
                if (Auth::attempt(['phone_number' => $input['phone'], 'password' => $input['password'], 'role_id' => config('api.constants.user.APP_USER_ROLE')])) {
                    $user = Auth::user();

                    if ($user->status == '0' && $user->phone_number_verified == 0) {
                        $userData = User::where('phone_number', $input['phone'])->first();
                        $otp      = $this->generatePIN(4);
                        $twilio   = new Client(env('TWILIO_ACCOUNT_SID'), env('TWILIO_SECRET_KEY'));
                        $sendSms  = $twilio->messages->create(
                            config('admin.constants.COUNTRY_CODE') . $userData->phone_number,
                            [
                                "body" => "You have requested for OTP, your otp is {$otp}",
                                "from" => env('TWILIO_TRIAL_NUMBER'),
                            ]
                        );
                        $userData->status                   = false;
                        $userData->verification_otp         = $otp;
                        $userData->verification_otp_sent_at = Carbon::now();
                        $userData->save();

                        //remove old and add new fcm token if api need it
                        $fcm_token = (!empty($input['deviceToken'])) ? trim($input['deviceToken']) : '';

                        FcmToken::where('user_id', $user->id)->delete();
                        $device = FcmToken::create([
                            'user_id'     => $user->id,
                            'fcm_token'   => $fcm_token,
                            'device_type' => $input['deviceType'],
                        ]);

                        \DB::table('oauth_access_tokens')->where('user_id', $user->id)->delete();

                        //generate passport access_token, refresh_token etc via internal request to oauth2
                        $token                  = [];
                        $token['token_type']    = "Bearer";
                        $token['expires_in']    = Carbon::now()->addMonths(6)->timestamp;
                        $token['access_token']  = $user->createToken(config("app.name"))->accessToken;
                        $token['refresh_token'] = $user->createToken(config("app.name"))->accessToken;

                        $profileData             = User::userProfileInfo($user->id);
                        $this->dataList          = $profileData;
                        $this->dataList['aws']   = CommonHelper::getAwsCredentials();
                        $this->dataList['paystack']   = CommonHelper::getPayStackCredentials();
                        $this->dataList['token'] = $token;

                        $this->code    = config('api.constants.httpCodes.SUCCESS');
                        $this->message = __('api/validation/user.success.otpSend');
                        return $this->sendResponse();
                    } else {
                        if ($user->status != 1) {

                            $this->code    = config('api.constants.httpCodes.ERROR');
                            $this->message = __('api/validation/user.error.blocked');
                            return $this->sendResponse();
                        }

                        //remove old and add new fcm token if api need it
                        $fcm_token = (!empty($input['deviceToken'])) ? trim($input['deviceToken']) : '';

                        FcmToken::where('user_id', $user->id)->delete();
                        $device = FcmToken::create([
                            'user_id'     => $user->id,
                            'fcm_token'   => $fcm_token,
                            'device_type' => $input['deviceType'],
                        ]);

                        \DB::table('oauth_access_tokens')->where('user_id', $user->id)->delete();

                        //generate passport access_token, refresh_token etc via internal request to oauth2
                        $token                  = [];
                        $token['token_type']    = "Bearer";
                        $token['expires_in']    = Carbon::now()->addMonths(6)->timestamp;
                        $token['access_token']  = $user->createToken(config("app.name"))->accessToken;
                        $token['refresh_token'] = $user->createToken(config("app.name"))->accessToken;

                        $profileData             = User::userProfileInfo($user->id);
                        $this->dataList          = $profileData;
                        $this->dataList['aws']   = CommonHelper::getAwsCredentials();
                        $this->dataList['paystack']   = CommonHelper::getPayStackCredentials();
                        $this->dataList['token'] = $token;
                        $this->code              = config('api.constants.httpCodes.SUCCESS');
                        $this->message           = __('api/validation/user.success.login');
                    }
                } else {
                    $this->code    = config('api.constants.httpCodes.ERROR');
                    $this->message = __('api/validation/user.error.login');
                }
                return $this->sendResponse();
            }
        } catch (\Exception $exception) {
            return $exception;
            $this->saveErrorLog($exception);
            return $this->sendError($exception);
        }
    }

    /**
     * Author: Jaidev
     * Function: register
     * Description: Register app user & return authentication token
     * Input: email, password & other input values
     * Output: auth token
     * Dated: 16/July/2021
     */
    public function register(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                if ($request->isJson()) {
                    $input = $request->json()->all();
                } else {
                    //$input = $request->getContent();
                    $input = $request->all();
                }
                $input = Input::only('firstName', 'lastName', 'email', 'phone', 'password', 'deviceToken', 'deviceType');
                // print_r($input);die;
                $validator = Validator::make($input, User::rules(), User::messages());
                if ($validator->fails()) {
                    $errorCode     = key(current($validator->errors()));
                    $this->code    = __("api/validation/user.$errorCode.code");
                    $this->message = $validator->errors()->first();
                    return $this->sendResponse();
                }
                $input['role_id'] = config('api.constants.user.APP_USER_ROLE');
                $otp              = $this->generatePIN(4);
                \DB::beginTransaction();
                //send sms to user
                $twilio  = new Client(env('TWILIO_ACCOUNT_SID'), env('TWILIO_SECRET_KEY'));
                $sendSms = $twilio->messages->create(
                    config('admin.constants.COUNTRY_CODE') . $input['phone'],
                    [
                        "body" => "Dear User,\n" . $otp . " is your OTP for verifying your mobile number. Please do not share it with anyone.\nRegards,\nTeam BMF",
                        "from" => env('TWILIO_TRIAL_NUMBER'),
                    ]
                );

                //check if SMS goes to user
                if ($twilio) {
                    $user = User::create([
                        'role_id'                  => config('api.constants.user.APP_USER_ROLE'),
                        'email'                    => trim($input['email']),
                        'country_code'             => config('api.constants.user.countryCode.default'),
                        'phone_number'             => trim($input['phone']),
                        'password'                 => trim($input['password']),
                        'first_name'               => trim($input['firstName']),
                        'last_name'                => trim($input['lastName']),
                        'device_type'              => trim($input['deviceType']),
                        'device_token'             => trim($input['deviceToken']),
                        'verification_otp'         => $otp,
                        'verification_otp_sent_at' => Carbon::now(),
                        'phone_number_verified'    => 0,
                        'status'                   => 0,
                    ]);
                    if (!empty($user->id)) {
                        $rollBack = false;
                        if ($request->hasFile('avatar')) {
                            //Storage::delete("public/pics/{$user->image}");
                            if (!\app\Model\Admin\User::upload_avatar($request->avatar, $user->id)) {
                                $rollBack = true;
                                \DB::rollBack();
                                $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
                                $this->code     = config('api.constants.httpCodes.ERROR');
                                $this->message  = __('api/user.error.202');
                            }
                        }

                        if (!empty($input['deviceToken'])) {

                            //remove old and add new fcm token if api need it
                            $fcm_token = trim($input['deviceToken']);

                            FcmToken::where('user_id', $user->id)->delete();
                            FcmToken::create([
                                'user_id'     => $user->id,
                                'fcm_token'   => $fcm_token,
                                'device_type' => $input['deviceType'],
                            ]);
                        }

                        if (!$rollBack) {
                            \DB::commit();
                            //generate passport access_token, refresh_token etc via internal request to oauth2

                            $token                  = [];
                            $token['token_type']    = "Bearer";
                            $token['expires_in']    = Carbon::now()->addMonths(6)->timestamp;
                            $token['access_token']  = $user->createToken(config("app.name"))->accessToken;
                            $token['refresh_token'] = $user->createToken(config("app.name"))->accessToken;

                            $profileData = User::userProfileInfo($user->id);

                            $this->dataList          = $profileData;
                            $this->dataList['token'] = $token;

                            $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
                            $this->code     = config('api.constants.httpCodes.SUCCESS');
                            $this->message  = __('api/validation/user.success.register');
                        }
                    } else {
                        $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
                        $this->code     = config('api.constants.httpCodes.ERROR');
                        $this->message  = __('api/validation/user.error.register');
                    }
                } else {
                    // if otp not sent
                    $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
                    $this->code     = config('api.constants.httpCodes.ERROR');
                    $this->message  = __('api/validation/user.error.otp_send_error');
                }

                return $this->sendResponse();
            }
        } catch (\Exception $e) {
            // dd($e->getMessage());
            $this->saveErrorLog($e);
            $this->httpCode = config('api.constants.httpCodes.SERVER_ERROR');
            $this->code     = config('api.constants.httpCodes.SERVER_ERROR');
            $this->message  = __('api/common.SERVER_ERROR');
            $this->message  = $e->getMessage();
            return $this->sendError();
        }
    }

    /**
     * @Author: NMG
     * @Function: logout
     * @Description: logout by deleting/revoking authentication token
     * @Dated: 18/Dec/2019
     * @Updated 18/Dec/2019
     */
    public function logout(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                if ($request->isJson()) {
                    $input = $request->json()->all();
                } else {
                    //$input = $request->getContent();
                    $input = $request->all();
                }
                $user = $request->user();
                if ($user->id) {
                    //delete fac_token if api request want to do so
                    \DB::table('fcm_tokens')
                        ->where('user_id', $user->id)
                        ->delete();

                    $request->user()->token()->delete();

                    // check if user is rider then change his status to offline
                    if ($user->is_delivery_person == 1) {
                        $userDeliveryPerson = DeliveryPerson::where(['user_id' => $user->id])->first();
                        if (!empty($userDeliveryPerson)) {
                            $user->is_active = 0;
                            $user->save();
                            $userDeliveryPerson->work_status = 0;
                            $userDeliveryPerson->save();
                        }
                    }
                }
                $this->code    = config('api.constants.httpCodes.SUCCESS');
                $this->message = __('api/validation/user.success.logout');
                return $this->sendResponse();
            }
        } catch (\Exception $exception) {
            $this->saveErrorLog($exception);
            $this->httpCode = config('api.constants.httpCodes.SERVER_ERROR');
            $this->code     = config('api.constants.httpCodes.SERVER_ERROR');
            $this->message  = __('api/common.SERVER_ERROR');
            return $this->sendError();
        }
    }

    /**
     * @Author: NMG
     * @Function: refreshToken
     * @Description: this will generate new access token after it's expiration using refresh_token
     * @Input: refresh_token
     * @Dated: 18/Dec/2019
     * @Updated 18/Dec/2019
     */
    // public function refreshToken(Request $request)
    // {
    //     try {
    //         if ($request->isMethod('post')) {
    //             if ($request->isJson()) {
    //                 $input = $request->json()->all();
    //             } else {
    //                 //$input = $request->getContent();
    //                 $input = $request->all();
    //             }
    //             $input = Input::only('refresh_token');
    //             $refresh_token = trim($input['refresh_token']);
    //             if (empty($refresh_token)) {
    //                 $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
    //                 $this->code = config('api.constants.httpCodes.ERROR');
    //                 $this->message = __('api/user.error.203');
    //             } else {
    //                 $client = \Laravel\Passport\Client::where('password_client', 1)->first();

    //                 $request->request->add([
    //                     'grant_type' => 'refresh_token',
    //                     'client_id' => $client->id,
    //                     'client_secret' => $client->secret,
    //                     'scope' => null,
    //                 ]);

    //                 // Fire off the internal request.
    //                 $proxy = Request::create(
    //                     'oauth/token',
    //                     'POST'
    //                 );
    //                 $token = json_decode(\Route::dispatch($proxy)->content());
    //                 if (!empty($token->message)) {
    //                     $this->code = config('api.constants.httpCodes.ERROR');
    //                     $this->message = $token->message;
    //                 } else {
    //                     $this->code = config('api.constants.httpCodes.SUCCESS');
    //                     $this->dataList['token'] = $token;
    //                     $this->message = __('api/validation/user.success.refreshToken');
    //                 }
    //             }
    //             return $this->sendResponse();
    //         }
    //     } catch (\Exception $exception) {
    //         $this->saveErrorLog($exception);
    //         $this->httpCode = config('api.constants.httpCodes.SERVER_ERROR');
    //         $this->code = config('api.constants.httpCodes.SERVER_ERROR');
    //         $this->message = __('api/common.SERVER_ERROR');
    //         return $this->sendError();
    //     }
    // }

    /**
     * Author: bibhash
     * Email : bibhash.shisodiya@nmgtechnologies.com
     * Function: Veryfy OTP in multiple scenario
     * Description: user provide otp which he get over email/phone
     * Output: OTP verified
     * Dated: 17/July/2021
     */

    public function verifyOtp(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                if ($request->isJson()) {
                    $input = $request->json()->all();
                } else {
                    $input = $request->all();
                }
            }

            $input      = $request->only('phone', 'otp', 'type');
            $validation = Validator::make($input, User::verifyOtp(), User::messages());

            if ($validation->fails()) {
                // $errorCode       = key(current($validator->errors()));
                $this->apiStatus = __("api.constants.httpCodes.ERROR");
                $this->message   = $validation->errors()->first();
                $this->code      = config('api.constants.httpCodes.ERROR');
                return $this->sendResponse();
            }

            //Registerd user
            $user = User::where('phone_number', $request->phone)->first();

            if (!empty($user->verification_otp)) {
                if ($user->verification_otp == $request->otp) {

                    if ($request->type == 1) {
                        $profileData             = User::userProfileInfo($user->id);
                        $this->dataList          = $profileData;
                        $token                   = [];
                        $token['token_type']     = "Bearer";
                        $token['expires_in']     = Carbon::now()->addMonths(6)->timestamp;
                        $token['access_token']   = $user->createToken(config("app.name"))->accessToken;
                        $token['refresh_token']  = $user->createToken(config("app.name"))->accessToken;
                        $this->dataList['token'] = $token;

                        // $user->verification_otp         = null;
                        $user->verification_otp_sent_at = null;
                        $user->phone_number_verified    = 1;
                        $user->status                   = true;
                        $user->save();


                        // dd($user->email);
                        // send registration mail to user //

                        if (!empty($user->email)) {
                            if (!empty($input['lang'])) {
                                \App::setLocale($input['lang']);
                            }
                            $params['replaceKeywords']['{USER_NAME}'] = $user->first_name;
                            $params['toEmail'] = $user->email;
                            $params['emailSlug'] = 'app_registration';
                            if (!$this->customMailer($params)) {
                                DB::rollBack();
                                return $this->processError('failed to send mail');
                            }
                        }
                        //end  sending registration mail to user //

                        $this->dataList['token'] = $token;
                        $this->dataList['aws'] = CommonHelper::getAwsCredentials();
                        $this->dataList['paystack'] = CommonHelper::getPayStackCredentials();
                        $this->code              = config('api.constants.httpCodes.SUCCESS');
                        $this->message           = __('api/validation/user.success.mobile_verified');
                    } else if ($request->type == 2) {
                    } else if ($request->type == 3) {
                    }
                } else {
                    $this->code      = __('api/validation/user.otp.code');
                    $this->apiStatus = config('api.constants.httpCodes.ERROR');
                    $this->message   = __('api/validation/user.error.wrong_otp');
                }
            } else {
                $this->code      = config('api.constants.httpCodes.ERROR');
                $this->apiStatus = config('api.constants.httpCodes.ERROR');
                $this->message   = __('api/validation/user.error.phone_error');
            }
            return $this->sendResponse();
        } catch (\Exception $exception) {
            $this->saveErrorLog($exception);
            $this->httpCode  = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
            $this->apiStatus = config('api.constants.httpCodes.ERROR');
            $this->message   = __('api/common.SERVER_ERROR');
            return $this->sendError();
        }
    }

    /**
     * Author: NMG
     * Function: Veryfy Email for latest registered user
     * Description: user provide otp which he get over email/phone
     * Dated: 09/June/2020
     */

    // public function verifyMobile(Request $request)
    // {
    //     try {
    //         if ($request->isMethod('post')) {
    //             if ($request->isJson()) {
    //                 $input = $request->json()->all();
    //             } else {
    //                 $input = $request->all();
    //             }
    //         }
    //         $input = $request->only('otp', 'mobile_no');

    //         $validation = Validator::make($input, User::verifyMobile());

    //         if ($validation->fails()) {
    //             $errorCode = key(current($validation->errors()));
    //             $this->apiStatus = __("api/user.$errorCode.code");
    //             $this->message = $validation->errors()->first();
    //             return $this->sendResponse();
    //         }

    //         //Registerd user
    //         $user = DB::table('users')->where('mobile_no', $request->mobile_no)->first();
    //         if (!empty($user->id)) {
    //             $otp = $user->verification_otp;
    //         }
    //         if ($otp == $request->otp) {
    //             $verification['status'] = true;
    //             User::where('id', $user->id)->update($verification);
    //             $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
    //             $this->apiStatus = config('api.constants.httpCodes.SUCCESS');
    //             $this->message = __('api/validation/user.success.mobile_verified');
    //         } else {
    //             $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
    //             $this->apiStatus = config('api.constants.httpCodes.ERROR');
    //             $this->message = __('api/validation/user.error.email_otp_error');
    //         }
    //         return $this->sendResponse();
    //     } catch (\Exception $exception) {
    //         $this->saveErrorLog($exception);
    //         $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
    //         $this->apiStatus = config('api.constants.httpCodes.ERROR');
    //         $this->message = __('api/common.SERVER_ERROR');
    //         return $this->sendError();
    //     }
    // }

    // public function verifyEmail(Request $request)
    // {
    //     try {
    //         if ($request->isMethod('post')) {
    //             if ($request->isJson()) {
    //                 $input = $request->json()->all();
    //             } else {
    //                 $input = $request->all();
    //             }
    //         }
    //         $input = $request->only('otp', 'email');
    //         $validation = Validator::make($input, User::verifyEmail());
    //         if ($validation->fails()) {
    //             $errorCode = key(current($validation->errors()));
    //             $this->apiStatus = __("api/user.$errorCode.code");
    //             $this->message = $validation->errors()->first();
    //             return $this->sendResponse();
    //         }
    //         //Registerd user
    //         $user = DB::table('users')->where('email', $request->email)->first();
    //         if (!empty($user->id)) {
    //             $otp = $user->verification_otp;
    //         }
    //         if ($otp == $request->otp) {
    //             $verification['email_verified_at'] = date('Y-m-d H:i:s');
    //             User::where('id', $user->id)->update($verification);
    //             $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
    //             $this->apiStatus = config('api.constants.httpCodes.SUCCESS');
    //             $this->message = __('api/validation/user.success.email_verified');
    //         } else {
    //             $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
    //             $this->apiStatus = config('api.constants.httpCodes.ERROR');
    //             $this->message = __('api/user.error.email_otp_error');
    //         }
    //         return $this->sendResponse();
    //     } catch (\Exception $exception) {
    //         $this->saveErrorLog($exception);
    //         $this->httpCode = config('api.constants.httpCodes.SUCCESS_WITH_RESPONSE_BODY');
    //         $this->apiStatus = config('api.constants.httpCodes.ERROR');
    //         $this->message = __('api/common.SERVER_ERROR');
    //         return $this->sendError();
    //     }
    // }

    ##################### below service not used by Mobile Team ########################

    public function testEcrypt()
    {
        $input  = Input::all();
        $string = json_encode($input);
        $result = $this->apiEncryption('encrypt', $string);

        $response = [
            'request' => $result,
        ];
        return response()->json($response, 200);
    }

    public function testDecrypt()
    {
        $input    = Input::all();
        $string   = $this->apiEncryption('decrypt', $input['input']);
        $result   = (array) json_decode($string);
        $response = [
            'response' => $result,
        ];
        return response()->json($response, 200);
    }
}
