<?php

namespace app\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use app\Model\Api\V1\Address;
use app\Transformers\AddressTransformer;
use Illuminate\Support\Facades\Validator;
use app\Http\Controllers\Api\V1\BaseController;

class AddressController extends BaseController
{
    /**
     * private variable address
     *
     * @var [object]
     */
    private $address;

    /**
     * constructor of class.
     *
     * @param Address $address
     */
    public function __construct(Address $address)
    {
        $this->address = $address;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {
            if ($request->user()->status == 1) {
                $request->request->add(['userId' => $request->user()->id]);
                $addresses =  $this->address->list($request);
                $this->dataList['addresses'] = (new AddressTransformer)->collection($addresses);
                $this->code    = config('api.constants.httpCodes.SUCCESS');
                $this->message = __('api/validation/user.success.addresses_list_fetch');
            } else {
                $this->code = config('api.constants.httpCodes.FORBIDDEN');
                $this->message = __('api/validation/user.error.blocked');
            }
            return $this->sendResponse();
        } catch (\Throwable $th) {
            return $this->processError($th);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            if ($request->isMethod('post')) {

                $user = $request->user();
                $input = $request->all();
                $input['contact_person'] = $request->contact_person ?? $request->user()->first_name . ' ' . $request->user()->last_name;
                $validation = Validator::make($input, Address::rules(), Address::messages());
                if ($validation->fails()) {
                    $this->httpCode = config('api.constants.httpCodes.SUCCESS');
                    $this->code     = config('api.constants.httpCodes.ERROR');
                    $this->message  = $validation->errors()->first();
                    return $this->sendResponse();
                }
                if ($request->user()->status == 1) {


                    $address =  $this->address->create([
                        'user_id' => $user->id,
                        'contact_person' => $input['contact_person'],
                        'address1' => $input['address1'],
                        'address2' => $input['address2'],
                        'city' => $input['city'],
                        'state' => $input['state'],
                        'zipcode' => $input['zipcode'],
                        'address_type' => $input['address_type'],
                        'latitude' => $input['latitude'] ?? null,
                        'longitude' => $input['longitude'] ?? null,
                    ]);
                    if ($address) {
                        $this->code    = config('api.constants.httpCodes.SUCCESS');
                        $this->message = __('api/validation/user.success.address_added');
                        $this->dataList = $address;
                    } else {
                        $this->code    = config('api.constants.httpCodes.SUCCESS');
                        $this->message = __('api/validation/user.error.address_added');
                    }
                } else {
                    $this->code = config('api.constants.httpCodes.FORBIDDEN');
                    $this->message = __('api/validation/user.error.blocked');
                }
                return $this->sendResponse();
            }
        } catch (\Throwable $th) {
            return $th;
            return $this->processError($th);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            if ($request->isMethod('put')) {
                if ($request->user()->status == 1) {
                    $user = $request->user();
                    $input = $request->all();
                    $input['contact_person'] = $request->contact_person ?? $request->user()->first_name . ' ' . $request->user()->last_name;
                    $address = $this->address->where('id', $id)->where('user_id', $user->id)->first();
                    if (!$address) {
                        $this->httpCode = config('api.constants.httpCodes.SUCCESS');
                        $this->code     = config('api.constants.httpCodes.ERROR');
                        $this->message  = __('api/validation/user.error.notOwned');
                        return $this->sendResponse();
                    }

                    $validation = Validator::make($input, Address::rules($id), Address::messages());
                    if ($validation->fails()) {
                        $this->httpCode = config('api.constants.httpCodes.SUCCESS');
                        $this->code     = config('api.constants.httpCodes.ERROR');
                        $this->message  = $validation->errors()->first();
                        return $this->sendResponse();
                    }

                    $address = $this->address->where('id', $id)->update([
                        'user_id' => $user->id,
                        'contact_person' => $input['contact_person'],
                        'address1' => $input['address1'],
                        'address2' => $input['address2'],
                        'city' => $input['city'],
                        'state' => $input['state'],
                        'zipcode' => $input['zipcode'],
                        'address_type' => $input['address_type'],
                        'latitude' => $input['latitude'] ?? null,
                        'longitude' => $input['longitude'] ?? null,
                    ]);
                    if ($address) {
                        $this->code    = config('api.constants.httpCodes.SUCCESS');
                        $this->message = __('api/validation/user.success.address_updated');
                    } else {
                        $this->code    = config('api.constants.httpCodes.SUCCESS');
                        $this->message = __('api/validation/user.error.address_updated');
                    }
                } else {
                    $this->code = config('api.constants.httpCodes.FORBIDDEN');
                    $this->message = __('api/validation/user.error.blocked');
                }
                return $this->sendResponse();
            }
        } catch (\Throwable $th) {
            return $this->processError($th);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        try {
            if ($request->isMethod('delete')) {
                if ($request->user()->status == 1) {


                    $user = $request->user();
                    $input = $request->all();
                    $input['contact_person'] = $request->contact_person ?? $request->user()->first_name . ' ' . $request->user()->last_name;
                    $address = $this->address->where('id', $id)->where('user_id', $user->id)->first();
                    if (!$address) {
                        $this->httpCode = config('api.constants.httpCodes.SUCCESS');
                        $this->code     = config('api.constants.httpCodes.ERROR');
                        $this->message  = __('api/validation/user.error.notOwned');
                        return $this->sendResponse();
                    }

                    if ($address->delete()) {
                        $this->code    = config('api.constants.httpCodes.SUCCESS');
                        $this->message = __('api/validation/user.success.address_deleted');
                    } else {
                        $this->code    = config('api.constants.httpCodes.SUCCESS');
                        $this->message = __('api/validation/user.error.address_deleted');
                    }
                } else {
                    $this->code = config('api.constants.httpCodes.FORBIDDEN');
                    $this->message = __('api/validation/user.error.blocked');
                }
                return $this->sendResponse();
            }
        } catch (\Throwable $th) {
            return $this->processError($th);
        }
    }
}
